% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sipni.R
\name{sipni_dictionary}
\alias{sipni_dictionary}
\title{SI-PNI Data Dictionary}
\usage{
sipni_dictionary(variable = NULL)
}
\arguments{
\item{variable}{Character. If provided, returns dictionary for a specific
variable only. Default: NULL (returns all variables).}
}
\value{
A tibble with columns: variable, description, code, label.
}
\description{
Returns a tibble with the data dictionary for the SI-PNI FTP data
(1994--2019), including variable descriptions and category labels.
}
\details{
The dictionary covers FTP data variables (DPNI/CPNI, 1994--2019).
API microdata (2020+) has description fields embedded in the data
itself (e.g., \code{descricao_vacina}, \code{nome_raca_cor_paciente}),
so a separate dictionary is not needed.
}
\examples{
sipni_dictionary()
sipni_dictionary("IMUNO")
sipni_dictionary("DOSE")
}
\seealso{
Other sipni: 
\code{\link{sipni_cache_status}()},
\code{\link{sipni_clear_cache}()},
\code{\link{sipni_data}()},
\code{\link{sipni_info}()},
\code{\link{sipni_variables}()},
\code{\link{sipni_years}()}
}
\concept{sipni}
