% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sih.R
\name{sih_data}
\alias{sih_data}
\title{Download SIH Hospital Admission Microdata}
\usage{
sih_data(
  year,
  month = NULL,
  vars = NULL,
  uf = NULL,
  diagnosis = NULL,
  parse = TRUE,
  col_types = NULL,
  cache = TRUE,
  cache_dir = NULL,
  lazy = FALSE,
  backend = c("arrow", "duckdb")
)
}
\arguments{
\item{year}{Integer. Year(s) of the data. Required.}

\item{month}{Integer. Month(s) of the data (1-12). If NULL (default),
downloads all 12 months. Example: \code{1} (January), \code{1:6} (first semester).}

\item{vars}{Character vector. Variables to keep. If NULL (default),
returns all available variables. Use \code{\link[=sih_variables]{sih_variables()}} to see
available variables.}

\item{uf}{Character. Two-letter state abbreviation(s) to download.
If NULL (default), downloads all 27 states.
Example: \code{"SP"}, \code{c("SP", "RJ")}.}

\item{diagnosis}{Character. CID-10 code pattern(s) to filter by principal
diagnosis (\code{DIAG_PRINC}). Supports partial matching (prefix).
If NULL (default), returns all diagnoses.
Example: \code{"I21"} (acute myocardial infarction), \code{"J"} (respiratory).}

\item{parse}{Logical. If TRUE (default), converts columns to
appropriate types (integer, double, Date) based on the variable
metadata. Use \code{\link[=sih_variables]{sih_variables()}} to see the target type for each
variable. Set to FALSE for backward-compatible all-character output.}

\item{col_types}{Named list. Override the default type for specific
columns. Names are column names, values are type strings:
\code{"character"}, \code{"integer"}, \code{"double"},
\code{"date_dmy"}, \code{"date_ymd"}, \code{"date_ym"}, \code{"date"}.
Example: \code{list(VAL_TOT = "character")} to keep VAL_TOT as character.}

\item{cache}{Logical. If TRUE (default), caches downloaded data for
faster future access.}

\item{cache_dir}{Character. Directory for caching. Default:
\code{tools::R_user_dir("healthbR", "cache")}.}

\item{lazy}{Logical. If TRUE, returns a lazy query object instead of a
tibble. Requires the \pkg{arrow} package. The lazy object supports
dplyr verbs (filter, select, mutate, etc.) which are pushed down
to the query engine before collecting into memory. Call
\code{dplyr::collect()} to materialize the result. Default: FALSE.}

\item{backend}{Character. Backend for lazy evaluation: \code{"arrow"}
(default) or \code{"duckdb"}. Only used when \code{lazy = TRUE}.
DuckDB backend requires the \pkg{duckdb} package.}
}
\value{
A tibble with hospital admission microdata. Includes columns
\code{year}, \code{month}, and \code{uf_source} to identify the source when multiple
years/months/states are combined.
}
\description{
Downloads and returns hospital admission microdata from DATASUS FTP.
Each row represents one hospital admission record (AIH).
Data is organized monthly -- one .dbc file per state (UF) per month.
}
\details{
Data is downloaded from DATASUS FTP as .dbc files (one per state per month).
The .dbc format is decompressed internally using vendored C code from the
blast library. No external dependencies are required.

SIH data is monthly, so downloading an entire year for all states requires
324 files (27 UFs x 12 months). Use \code{uf} and \code{month} to limit downloads.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# all admissions in Acre, January 2022
ac_jan <- sih_data(year = 2022, month = 1, uf = "AC")

# heart attacks in Sao Paulo, first semester 2022
infarct_sp <- sih_data(year = 2022, month = 1:6, uf = "SP",
                        diagnosis = "I21")

# only key variables, Rio de Janeiro, March 2022
sih_data(year = 2022, month = 3, uf = "RJ",
         vars = c("DIAG_PRINC", "DT_INTER", "SEXO",
                  "IDADE", "MORTE", "VAL_TOT"))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=censo_populacao]{censo_populacao()}} for population denominators to calculate
hospitalization rates.

Other sih: 
\code{\link{sih_cache_status}()},
\code{\link{sih_clear_cache}()},
\code{\link{sih_dictionary}()},
\code{\link{sih_info}()},
\code{\link{sih_variables}()},
\code{\link{sih_years}()}
}
\concept{sih}
