% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof.R
\name{pof_variables}
\alias{pof_variables}
\title{List POF variables}
\usage{
pof_variables(
  year = "2017-2018",
  register = NULL,
  search = NULL,
  cache_dir = NULL,
  refresh = FALSE
)
}
\arguments{
\item{year}{Character. POF edition (e.g., "2017-2018"). Default is "2017-2018".}

\item{register}{Character. Register name (e.g., "morador", "domicilio").
If NULL, returns variables from all registers. Default is NULL.}

\item{search}{Character. Optional search term to filter variables by name
or description. Default is NULL.}

\item{cache_dir}{Character. Directory for caching downloaded files.
Default uses \code{tools::R_user_dir("healthbR", "cache")}.}

\item{refresh}{Logical. If TRUE, re-download even if file exists in cache.
Default is FALSE.}
}
\value{
A tibble with columns: variable, description, position, length, register.
}
\description{
Returns a list of available variables in the POF microdata with their labels.
This is a convenience wrapper around \code{\link{pof_dictionary}} that
returns a simplified view.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
pof_variables("2017-2018", "morador", cache_dir = tempdir())
pof_variables("2017-2018", "domicilio", search = "ebia", cache_dir = tempdir())
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{pof_dictionary}}, \code{\link{pof_data}}

Other pof: 
\code{\link{pof_cache_status}()},
\code{\link{pof_clear_cache}()},
\code{\link{pof_data}()},
\code{\link{pof_dictionary}()},
\code{\link{pof_info}()},
\code{\link{pof_registers}()},
\code{\link{pof_years}()}
}
\concept{pof}
