% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pns.R
\name{pns_variables}
\alias{pns_variables}
\title{List PNS variables}
\usage{
pns_variables(year = 2019, module = NULL, cache_dir = NULL, refresh = FALSE)
}
\arguments{
\item{year}{Numeric. Year to get variables for (2013 or 2019).
Default is 2019.}

\item{module}{Character. Filter by module code (e.g., "J", "K", "L").
NULL returns all modules. Default is NULL.}

\item{cache_dir}{Character. Directory for caching downloaded files.
Default uses \code{tools::R_user_dir("healthbR", "cache")}.}

\item{refresh}{Logical. If TRUE, re-download even if file exists in cache.
Default is FALSE.}
}
\value{
A tibble with variable names and labels.
}
\description{
Returns a list of available variables in the PNS microdata with their labels.
This is a convenience wrapper around \code{\link{pns_dictionary}} that
returns only unique variable names and labels.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# list all variables for 2019
pns_variables(year = 2019, cache_dir = tempdir())

# list variables for a specific module
pns_variables(year = 2019, module = "J", cache_dir = tempdir())
\dontshow{\}) # examplesIf}
}
