% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryWO_hce.R
\name{summaryWO.hce}
\alias{summaryWO.hce}
\title{Win odds summary for \code{hce} objects}
\usage{
\method{summaryWO}{hce}(x, ...)
}
\arguments{
\item{x}{an \code{hce} object.}

\item{...}{additional parameters.}
}
\value{
a list containing the summary of wins, losses, and ties. It contains the following named objects:
\itemize{
\item summary a data frame containing number of wins, losses, and ties by treatment group and the overall number of comparisons.
\item WO calculated WO (win odds) and WP (win probability) and their standard errors.
}
}
\description{
Win odds summary for \code{hce} objects
}
\examples{
COVID19HCE <- hce(GROUP = COVID19$GROUP, TRTP = COVID19$TRTP)
summaryWO(COVID19HCE, ref = "Placebo")
}
\seealso{
\code{\link[=calcWO]{calcWO()}}, \code{\link[=summaryWO]{summaryWO()}}, \code{\link[=summaryWO.data.frame]{summaryWO.data.frame()}}, \code{\link[=summaryWO.formula]{summaryWO.formula()}}, \code{\link[=summaryWO.adhce]{summaryWO.adhce()}} methods.
}
