% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hassediagrams.R
\docType{package}
\encoding{UTF-8}
\name{hassediagrams}
\alias{hassediagrams}
\title{Hasse diagram of the layout structure and restricted layout structure}
\description{
Returns a Hasse diagram of the 'layout structure' or the 'restricted layout structure' 
of an experimental design.
}
\details{
The package consists of two main functions: \code{\link[hassediagrams]{hasselayout}} and \code{\link[hassediagrams]{hasserls}}. 
The first function generates the Hasse diagram of the layout structure of an experimental design. 
The second function is used to generate the Hasse diagram of the restricted layout 
structure of an experimental design.
}
\references{
Bate, S.T. and Chatfield, M.J. (2016a), Identifying the structure of the experimental design.  
Journal of Quality Technology, 48, 343-364.

Bate, S.T. and Chatfield, M.J. (2016b), Using the structure of the experimental design and  
the randomization to construct a mixed model. Journal of Quality Technology, 48, 365-387.

Box, G.E.P., Hunter, J.S., and Hunter, W.G., (1978), Statistics for Experimenters.  
New York, Wiley.

Joshi, D.D. (1987), Linear Estimation and Design of Experiments. Wiley Eastern, New Delhi.

Williams, E.R., Matheson, A.C. and Harwood, C.E. (2002), Experimental design and analysis  
for tree improvement. 2nd edition. CSIRO, Melbourne, Australia.
}
\seealso{
For dataset details, see:
- \code{\link{concrete}}
- \code{\link{dental}}
- \code{\link{human}}
- \code{\link{analytical}}
}
\author{
Damianos Michaelides (Maintainer) <dm3g15@soton.ac.uk>  
Simon Bate <simon.t.bate@gsk.com>  
Marion Chatfield
}
\keyword{internal}
