% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.r
\name{h5_class}
\alias{h5_class}
\title{Get R Class of an HDF5 Object or Attribute}
\usage{
h5_class(file, name, attr = NULL)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The full path of the object (group or dataset) to check.}

\item{attr}{The name of an attribute to check. If \code{NULL} (default), the function
checks the class of the object itself.}
}
\value{
A character string representing the R class (e.g., \code{"integer"}, \code{"numeric"},
\code{"complex"}, \code{"character"}, \code{"factor"}, \code{"raw"}, \code{"list"}, \code{"NULL"}).
Returns \code{NA_character_} for HDF5 types that \code{h5lite} cannot read.
}
\description{
Inspects an HDF5 object (or an attribute attached to it) and returns the R class
that \code{h5_read()} would produce.
}
\details{
This function determines the resulting R class by inspecting the storage metadata.

\itemize{
\item \strong{Group} \eqn{\rightarrow} \code{"list"}
\item \strong{Integer} \eqn{\rightarrow} \code{"numeric"}
\item \strong{Floating Point} \eqn{\rightarrow} \code{"numeric"}
\item \strong{String} \eqn{\rightarrow} \code{"character"}
\item \strong{Complex} \eqn{\rightarrow} \code{"complex"}
\item \strong{Enum} \eqn{\rightarrow} \code{"factor"}
\item \strong{Opaque} \eqn{\rightarrow} \code{"raw"}
\item \strong{Compound} \eqn{\rightarrow} \code{"data.frame"}
\item \strong{Null} \eqn{\rightarrow} \code{"NULL"}
}
}
\examples{
file <- tempfile(fileext = ".h5")

h5_write(1:10, file, "my_ints", as = "int32")
h5_class(file, "my_ints") # "numeric"

h5_write(mtcars, file, "mtcars")
h5_class(file, "mtcars") # "data.frame"

h5_write(c("a", "b", "c"), file, "strings")
h5_class(file, "strings") # "character"

h5_write(c(1, 2, 3), file, "my_floats", as = "float64")
h5_class(file, "my_floats") # "numeric"

unlink(file)
}
\seealso{
\code{\link[=h5_typeof]{h5_typeof()}}, \code{\link[=h5_read]{h5_read()}}
}
