% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiply_ef.R
\name{multiply_ef}
\alias{multiply_ef}
\title{Multiply emission factors by distances}
\usage{
multiply_ef(
  fleet_composition,
  dist,
  ef,
  aggregate = TRUE,
  prefix = NULL,
  as_list = TRUE
)
}
\arguments{
\item{fleet_composition}{vector; Fleet composition, which is a distribution
of fleet based on frequency. If there is only one, 'fleet_composition'
is 1.0.}

\item{dist}{units ('km'); Length of each link in km.}

\item{ef}{list or data.table;    Emission factors.}

\item{aggregate}{logical; if TRUE (default) emissions are aggregated by
pollutant.}

\item{prefix}{character; Add prefix into emissions names. Missing parameter
(default) means empty prefix.}

\item{as_list}{logical. If \code{TRUE} (default), the function returns the output
in a \code{list} format. If \code{FALSE}, the output is returned in a \code{data.table}
format.}
}
\value{
units ('g'); emissions per link.
}
\description{
Calculate hot exhaust emissions by multiplying emission factors by distances
weighted by fleet composition profile.
}
\keyword{internal}
