% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_number_si}
\alias{vec_fmt_number_si}
\title{Format a vector as numbers with SI prefixes}
\usage{
vec_fmt_number_si(
  x,
  unit = NULL,
  decimals = 2,
  drop_trailing_zeros = FALSE,
  drop_trailing_dec_mark = TRUE,
  scale_by = 1,
  prefix_mode = c("engineering", "decimal"),
  pattern = "{x}",
  sep_mark = ",",
  dec_mark = ".",
  force_sign = FALSE,
  incl_space = TRUE,
  locale = NULL,
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{\emph{The input vector}

\code{vector(numeric|integer)} // \strong{required}

This is the input vector that will undergo transformation to a character
vector of the same length. Values within the vector will be formatted.}

\item{unit}{\emph{Unit to append to formatted values}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

A character string specifying the unit to append after the SI prefix
(e.g., \code{"g"} for grams, \code{"W"} for watts, \code{"Hz"} for hertz, \code{"m"} for meters).
If \code{NULL}, only the prefix will be shown. The unit can also be dynamically
specified per row using \code{\link[=from_column]{from_column()}}.}

\item{decimals}{\emph{Number of decimal places}

\code{scalar<numeric|integer>(val>=0)} // \emph{default:} \code{2}

The exact number of decimal places to display in the mantissa. If both
\code{decimals} and \code{n_sigfig} are provided, \code{n_sigfig} takes precedence.}

\item{drop_trailing_zeros}{\emph{Drop trailing zeros}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Remove trailing zeros after the decimal point (e.g., "1.50" becomes "1.5").}

\item{drop_trailing_dec_mark}{\emph{Drop trailing decimal mark}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Remove the decimal mark if all decimal places are zero (e.g., "1." becomes
"1").}

\item{scale_by}{\emph{Scale values by a fixed multiplier}

\verb{scalar<numeric|integer>} // \emph{default:} \code{1}

All numeric values will be multiplied by the \code{scale_by} value before
undergoing formatting. Since the \code{default} value is \code{1}, no values will be
changed unless a different multiplier value is supplied. This is useful
for unit conversions, such as using \code{\link[=unit_conversion]{unit_conversion()}} to convert
horsepower to watts before formatting with SI prefixes.}

\item{prefix_mode}{\emph{Type of SI prefixes to use}

\verb{singl-kw:[engineering|decimal]} // \emph{default:} \code{"engineering"}

The type of SI prefixes to use. Options are \code{"engineering"} (powers of
1000 only) or \code{"decimal"} (all SI prefixes including powers of 10 and 100).
See the \emph{SI Prefix Modes} section for details.}

\item{pattern}{\emph{Decoration pattern}

\verb{scalar<character>} // \emph{default:} \code{"{x}"}

A formatting pattern for decorating values. Use \code{{x}} to represent the
formatted value (including prefix and unit).}

\item{sep_mark}{\emph{Thousands separator}

\verb{scalar<character>} // \emph{default:} \code{","}

The character to use as the thousands separator. Overridden if \code{locale} is
provided.}

\item{dec_mark}{\emph{Decimal mark}

\verb{scalar<character>} // \emph{default:} \code{"."}

The character to use as the decimal point. Overridden if \code{locale} is
provided.}

\item{force_sign}{\emph{Force positive sign}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

Force the display of a plus sign for positive values.}

\item{incl_space}{\emph{Include a space between the value and the unit symbol}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

An option for whether to include a space between the numerical value and
the SI prefix + unit (e.g., \code{TRUE} for "1.5 kW", \code{FALSE} for "1.5kW"). Per
SI convention, there should be a space between the value and the unit
symbol.}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for formatting values
according to the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). We can call \code{\link[=info_locales]{info_locales()}} for a
useful reference for all of the locales that are supported.}

\item{output}{\emph{Output format}

\verb{singl-kw:[auto|plain|html|latex|rtf|word]} // \emph{default:} \code{"auto"}

The output style of the resulting character vector. This can either be
\code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"}, or
\code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the \code{"auto"}
option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
With numeric values in a vector, we can format the values with SI (International
System of Units) prefixes. These prefixes like k (kilo), M (mega), G (giga),
and m (milli) scale numbers in either powers of 1000 (engineering mode) or
powers of 10 and 100 (decimal mode).

We have control over the formatting with the following options:
\itemize{
\item decimals: choice of the number of decimal places, option to drop
trailing zeros, and a choice of the decimal symbol
\item scaling: we can choose to scale targeted values by a multiplier value
(useful for unit conversions)
\item SI prefix mode: choose between engineering prefixes (powers of 1000) or
decimal prefixes (all SI prefixes)
\item units: an optional unit designation for the values
\item pattern: option to use a text pattern for decoration of the formatted
values
\item locale-based formatting: providing a locale ID will result in
formatting specific to the chosen locale
}
}
\section{Examples}{


Let's create a numeric vector for the next few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{num_vals <- c(1.5e9, 2.7e6, 4200, 0.3, 0.00012, 2.4e-8)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_number_si()} with the default options will create a
character vector with values formatted with SI prefixes. Any \code{NA} values
remain as \code{NA} values. The rendering context will be autodetected unless
specified in the \code{output} argument (here, it is of the \code{"plain"} output
type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number_si(num_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "1.50 G" "2.70 M" "4.20 k" "300.00 m" "120.00 u" "24.00 n"
}\if{html}{\out{</div>}}

We can add a unit designation to all values with the \code{unit} option:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number_si(num_vals, unit = "W")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "1.50 GW" "2.70 MW" "4.20 kW" "300.00 mW" "120.00 uW" "24.00 nW"
}\if{html}{\out{</div>}}

We can change the number of decimal places with the \code{decimals} option:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number_si(num_vals, unit = "g", decimals = 0)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "2 Gg" "3 Mg" "4 kg" "0 g" "0 g" "0 g"
}\if{html}{\out{</div>}}

If we are formatting for a different locale, we could supply the locale ID
and \strong{gt} will handle any locale-specific formatting options:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number_si(num_vals, unit = "m", locale = "fr")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "1,50 Gm" "2,70 Mm" "4,20 km" "300,00 mm" "120,00 um" "24,00 nm"
}\if{html}{\out{</div>}}

The \code{scale_by} option is useful for unit conversions. For instance, to
convert meters to millimeters:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number_si(c(0.5, 1.2, 3.8), unit = "m", scale_by = 1000)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "500.00 mm" "1.20 km" "3.80 km"
}\if{html}{\out{</div>}}

We can control the space between the number and unit with \code{incl_space}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number_si(num_vals, unit = "Hz", incl_space = FALSE, decimals = 1)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "1.5GHz" "2.7MHz" "4.2kHz" "300.0mHz" "120.0uHz" "24.0nHz"
}\if{html}{\out{</div>}}

As a last example, one can wrap the values in a pattern with the \code{pattern}
argument. Note here that \code{NA} values won't have the pattern applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_number_si(num_vals, pattern = "[\{x\}]")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "[1.50 G]" "[2.70 M]" "[4.20 k]" "[300.00 m]" "[120.00 u]" "[24.00 n]"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

15-5
}

\section{Function Introduced}{

\code{v1.2.0} (December 16, 2025)
}

\seealso{
The variant function intended for formatting \strong{gt} table data:
\code{\link[=fmt_number_si]{fmt_number_si()}}.

Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_date}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_index}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_number}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_percent}()},
\code{\link{vec_fmt_roman}()},
\code{\link{vec_fmt_scientific}()},
\code{\link{vec_fmt_spelled_num}()},
\code{\link{vec_fmt_time}()}
}
\concept{vector formatting functions}
