% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_all_caps}
\alias{opt_all_caps}
\title{Option to use all caps in select table locations}
\usage{
opt_all_caps(
  data,
  all_caps = TRUE,
  locations = c("column_labels", "stub", "row_group")
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{all_caps}{\emph{Use all-caps transformation}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

A logical value to indicate whether the text transformation to all caps
should be performed (\code{TRUE}, the default) or reset to default values
(\code{FALSE}) for the \code{locations} targeted.}

\item{locations}{\emph{Locations to target}

\verb{mult-kw:[column_labels|stub|row_group]} // \emph{default:} \code{c("column_labels", "stub", "row_group")}

Which locations should undergo this text transformation? By default it
includes all of the \code{"column_labels"}, the \code{"stub"}, and the \code{"row_group"}
locations. However, we could just choose one or two of those.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Sometimes an all-capitalized look is suitable for a table. With the
\code{opt_all_caps()} function, we can transform characters in the column labels,
the stub, and in all row groups in this way (and there's control over which
of these locations are transformed).

This function serves as a convenient shortcut for \verb{<gt_tbl> |> tab_options(<location>.text_transform = "uppercase", <location>.font.size = pct(80), <location>.font.weight = "bolder")} (for all \code{locations} selected).
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table with a number of table
parts added (using functions like \code{\link[=summary_rows]{summary_rows()}}, \code{\link[=grand_summary_rows]{grand_summary_rows()}},
and more). Following that, we'll ensure that all text in the column labels,
the stub, and in all row groups is transformed to all caps using
\code{opt_all_caps()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt(rowname_col = "row", groupname_col = "group") |>
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = c("min", "max")
  ) |>
  grand_summary_rows(
    columns = currency,
    fns = total ~ sum(., na.rm = TRUE)
  ) |>
  tab_source_note(source_note = "This is a source note.") |>
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) |>
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) |>
  opt_all_caps()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_all_caps_1.png" alt="This image of a table was generated from the first code example in the `opt_all_caps()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-10
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_footnote_order}()},
\code{\link{opt_footnote_spec}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_interactive}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
