% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune-specs.R
\name{tune_dep}
\alias{tune_dep}
\title{Dependent tuning specification}
\usage{
tune_dep(depends_on, map)
}
\arguments{
\item{depends_on}{Character vector of argument names this specification
depends on.}

\item{map}{A function returning either a \verb{tune_*()} specification or
a fixed value. The function should have arguments matching
\code{depends_on} (or use \code{...}).}
}
\value{
A \code{gstune_spec} object.
}
\description{
\code{tune_dep()} defines candidates for one argument as a function of other
arguments.
}
\examples{
# sfupar depends on sfu
tune_dep(
  depends_on = "sfu",
  map = function(sfu) {
    if (identical(sfu, gsDesign::sfLDOF)) tune_fixed(0) else tune_seq(-4, 4, 9)
  }
)
}
