% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate.R
\name{gr_check_data}
\alias{gr_check_data}
\title{Check the correctness of data frame for separating}
\usage{
gr_check_data(df)
}
\arguments{
\item{df}{\code{data.frame} with four columns: date, runoff, temperature, precipitation, as required by \code{\link[=gr_separate]{gr_separate()}}.}
}
\value{
stops execution if \code{df} contains the wrong number of columns, or the columns have the wrong types, or the data in columns is incorrect (e.g. runoff or precipitation are negative).
}
\description{
This function is called inside \code{\link[=gr_separate]{gr_separate()}}, but can be used explicitly inside your code.
}
\examples{
library(grwat)

# example Spas-Zagorye data is included with grwat package
data(spas)
head(spas)

gr_check_data(spas)

# raw Spas-Zagorye data represents date components
# in columns and does not contain meteorologgical variables
path = system.file("extdata", "spas-zagorye.txt", 
                   package = "grwat")

hdata_raw = read.delim(path, header = FALSE, 
                       sep = ' ', na.strings = c('-999', '-999.0', '-'),
                       col.names = c('d', 'm', 'y', 'q'))

print(hdata_raw)

try(gr_check_data(hdata_raw))



}
