% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otgrid.R, R/otgridtransport.R
\name{plot.otgrid}
\alias{plot.otgrid}
\alias{plot.otgridtransport}
\title{Plots for two-dimensional Optimal Transport}
\usage{
\method{plot}{otgrid}(x, num.col = 256, useRaster = TRUE, ...)

\method{plot}{otgridtransport}(x, num.col = 256, useRaster = TRUE, back.col = "lightblue", ...)
}
\arguments{
\item{x}{an object of class \code{"otgrid"} or \code{"otgridtransport"}}

\item{num.col}{number of colors (grey) to use.}

\item{useRaster}{parameter passed to the \code{\link{image}} function.}

\item{...}{further arguments (currently unused).}

\item{back.col}{color of the background.}
}
\value{
No return value, called for side effects.
}
\description{
Plot two-dimensional grids or visualize the pivot measure.
}
\details{
For objects of class \code{"otgrid"}, the grid is plotted as a greyscale image.

For objects of class \code{"otgridtransport"}, the pivot measure is visualized as follows: the two grids of the transport are plotted
in the left upper (\code{from}) and right lower (\code{to}) corner. The pivot measure is in the left lower corner such that the marginals match.
}
\seealso{
pivot measure \code{\link{pivot_measure}}, grid \code{\link{otgrid}}
}
