% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{ApplyContrasts}
\alias{ApplyContrasts}
\title{Apply a function over contrasts}
\usage{
ApplyContrasts(
  data,
  analysis,
  name.prefix,
  contrasts,
  mode.slot = NULL,
  genes = NULL,
  table = TRUE,
  verbose = FALSE,
  FUN,
  ...
)
}
\arguments{
\item{data}{the grandR object}

\item{analysis}{a plain name, only used for status messages}

\item{name.prefix}{the prefix for the new analysis name; a dot and the column names of the contrast matrix are appended; can be NULL (then only the contrast matrix names are used)}

\item{contrasts}{contrast matrix that defines all pairwise comparisons, generated using \link{GetContrasts}}

\item{mode.slot}{which slot to take expression values from}

\item{genes}{restrict analysis to these genes; NULL means all genes}

\item{table}{use GetTable and not GetMatrix}

\item{verbose}{print status messages?}

\item{FUN}{a function taking 1. the data matrix, 2. a logical vector indicating condition A and 3. a logical vector indicating condition B}

\item{...}{further parameters forward to FUN}
}
\value{
a new grandR object with added analysis tables (that were returned by FUN)
}
\description{
Helper function to run many pairwise comparisons using a contrast matrix
}
\details{
To implement most pairwise analyses, you only have to define FUN; see the source code of \link{LFC} for an example!
}
\seealso{
\link{LFC},\link{PairwiseDESeq2},\link{GetContrasts}
}
\concept{helper}
