% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.plot.partial.dependence.R
\name{gpb.plot.partial.dependence}
\alias{gpb.plot.partial.dependence}
\title{Plot partial dependence plots}
\usage{
gpb.plot.partial.dependence(model, data, variable, n.pt = 100,
  subsample = pmin(1, n.pt * 100/nrow(data)), discrete.x = FALSE,
  which.class = NULL, xlab = deparse(substitute(variable)), ylab = "",
  type = if (discrete.x) "p" else "b", main = "",
  return_plot_data = FALSE, ...)
}
\arguments{
\item{model}{A \code{gpb.Booster} model object}

\item{data}{A \code{matrix} with data for creating partial dependence plots}

\item{variable}{A \code{string} with a name of the column or an \code{integer} 
with an index of the column in \code{data} for which a dependence plot is created}

\item{n.pt}{Evaluation grid size (used only if x is not discrete)}

\item{subsample}{Fraction of random samples in \code{data} to be used for calculating the partial dependence plot}

\item{discrete.x}{A \code{boolean}. If TRUE, the evaluation grid is set to the unique values of x}

\item{which.class}{An \code{integer} indicating the class in multi-class classification (value from 0 to num_class - 1)}

\item{xlab}{Parameter passed to \code{plot}}

\item{ylab}{Parameter passed to \code{plot}}

\item{type}{Parameter passed to \code{plot}}

\item{main}{Parameter passed to \code{plot}}

\item{return_plot_data}{A \code{boolean}. If TRUE, the data for creating the partial dependence  plot is returned}

\item{...}{Additional parameters passed to \code{plot}}
}
\value{
A two-dimensional \code{matrix} with data for creating the partial dependence plot.
This is only returned if \code{return_plot_data==TRUE}
}
\description{
Plot partial dependence plots
}
\examples{
\donttest{
library(gpboost)
data(GPBoost_data, package = "gpboost")

gp_model <- GPModel(group_data = group_data[,1], likelihood = "gaussian")
gpboost_model <- gpboost(data = X,
                         label = y,
                         gp_model = gp_model,
                         nrounds = 16,
                         learning_rate = 0.05,
                         max_depth = 6,
                         min_data_in_leaf = 5,
                         verbose = 0)
gpb.plot.partial.dependence(gpboost_model, X, variable = 1)
}
}
\author{
Fabio Sigrist (adapted from a version by Michael Mayer)
}
