% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_grid.R
\name{gt_make_grid}
\alias{gt_make_grid}
\title{Creates Grid to Query Google Traffic}
\usage{
gt_make_grid(
  polygon,
  zoom,
  height_width_max = 2000,
  height = NULL,
  width = NULL,
  reduce_hw = 10
)
}
\arguments{
\item{polygon}{Polygon (\code{sf} object or \code{SpatialPolygonsDataframe}) in WGS84 CRS the defines region to be queried.}

\item{zoom}{Zoom level; integer from 5 to 20. For more information about how zoom levels correspond to pixel size, see \href{https://wiki.openstreetmap.org/wiki/Zoom_levels}{here} and \href{https://developers.google.com/maps/documentation/javascript/overview#zoom-levels}{here}.}

\item{height_width_max}{Maximum pixel height and width to check using for each grid (pixel length depends on zoom). If the same number of grids can be made with a smaller height/width, the function will use a smaller height/width. If \code{height} and \code{width} are specified, that height and width will be used and \code{height_width_max} will be ignored. (Default: \code{2000})}

\item{height}{Height, in pixels, for each grid (pixel length depends on zoom). Enter a \code{height} to manually specify the height; otherwise, a height of \code{height_width_max} or smaller will be used.}

\item{width}{Pixel, in pixels, for each grid (pixel length depends on zoom). Enter a \code{width} to manually specify the width; otherwise, a width of \code{height_width_max} or smaller will be used.}

\item{reduce_hw}{Number of pixels to reduce height/width by. Doing so creates some overlap between grids to ensure there is not blank space between grids. (Default: 10).}
}
\value{
Returns an sf dataframe with the locations to query, including parameters needed for \code{\link[=gt_make_raster_from_grid]{gt_make_raster_from_grid()}}
}
\description{
Creates a grid of sf polygons, where traffic data for each polygon can then be queried using \code{\link[=gt_make_raster_from_grid]{gt_make_raster_from_grid()}}.
}
\examples{
## Make polygon
poly_sf <- c(xmin = -74.02426,
             xmax = -73.91048,
             ymin = 40.70042,
             ymax = 40.87858) |>
  sf::st_bbox() |>
  sf::st_as_sfc() |>
  sf::st_as_sf()

sf::st_crs(poly_sf) <- 4326

## Make grid using polygon
grid_sf <- gt_make_grid(polygon = poly_sf,
                        height  = 2000,
                        width   = 2000,
                        zoom    = 16)

}
