% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models_gipsLDA.R
\name{gipslda}
\alias{gipslda}
\alias{gipslda.default}
\alias{gipslda.data.frame}
\alias{gipslda.formula}
\alias{gipslda.matrix}
\alias{model.frame.gipslda}
\alias{print.gipslda}
\alias{coef.gipslda}
\alias{plot.gipslda}
\alias{pairs.gipslda}
\title{Linear Discriminant Analysis with gips Covariance Projection}
\usage{
gipslda(x, ...)

\method{gipslda}{formula}(formula, data, ..., subset, na.action)

\method{gipslda}{default}(x, grouping, prior = proportions,
  tol = 1e-4, weighted_avg = FALSE,
  MAP = TRUE, optimizer = NULL, max_iter = NULL, ...)

\method{gipslda}{data.frame}(x, ...)

\method{gipslda}{matrix}(x, grouping, ..., subset, na.action)
}
\arguments{
\item{x}{(required if no formula is given as the principal argument)
a matrix or data frame or Matrix containing the explanatory variables.}

\item{...}{Arguments passed to or from other methods.}

\item{formula}{A formula of the form \code{groups ~ x1 + x2 + ...}.
The response is the grouping factor and the right-hand side specifies
the (non-factor) discriminators.}

\item{data}{An optional data frame, list or environment from which variables
specified in \code{formula} are preferentially taken.}

\item{grouping}{(required if no formula principal argument is given)
a factor specifying the class for each observation.}

\item{prior}{The prior probabilities of class membership. If unspecified,
the class proportions for the training set are used.}

\item{tol}{A tolerance to decide if a matrix is singular; variables whose
variance is less than \code{tol^2} are rejected.}

\item{subset}{An index vector specifying the cases to be used in the training
sample. (NOTE: must be named.)}

\item{na.action}{A function specifying the action for \code{NA}s.
#' @param weighted_avg Logical; if TRUE, uses a weighted average of
class-specific covariance matrices instead of the pooled covariance.}

\item{MAP}{Logical; whether to compute a Maximum A Posteriori
gips projection of the covariance matrix.}

\item{optimizer}{Character; optimization method used by gips
(e.g. \code{"BF"} or \code{"MH"}).}

\item{max_iter}{Maximum number of iterations for the optimizer.}

\item{weighted_avg}{Logical; Whether to compute scatter from all classes
at once or to compute them within classes and compute the main one as
average weighted by class proportions.}
}
\value{
An object of class \code{"gipslda"} containing:
\itemize{
\item \code{prior}: prior class probabilities
\item \code{counts}: number of observations per class
\item \code{means}: group means
\item \code{scaling}: linear discriminant coefficients
\item \code{svd}: singular values of the between-class scatter
\item \code{N}: number of observations
\item \code{optimization_info}: information about the gips optimization
\item \code{call}: matched call
}
}
\description{
Linear discriminant analysis (LDA) using covariance matrices projected
via the \emph{gips} framework to enforce permutation symmetry and improve
numerical stability.
}
\details{
This function is a minor modification of \code{\link[MASS]{lda}}, replacing
the classical sample covariance estimators by projected covariance matrices
obtained using \code{project_covs()}.

Unlike classical LDA, the within-class covariance matrix is first
projected onto a permutation-invariant structure using the gips
framework. This can stabilize covariance estimation in high dimensions
or when symmetry assumptions are justified.

The choice of optimizer and MAP estimation affects both the covariance
estimate and the resulting discriminant directions.

See Chojecki et al. (2025) for theoretical background.
}
\note{
This function is inspired by \code{\link[MASS]{lda}} but is not
a drop-in replacement. The covariance estimator, optimization
procedure, and returned object differ substantially.
}
\examples{
Iris <- data.frame(rbind(iris3[, , 1], iris3[, , 2], iris3[, , 3]),
  Sp = rep(c("s", "c", "v"), rep(50, 3))
)
train <- sample(1:150, 75)
z <- gipslda(Sp ~ ., Iris, prior = c(1, 1, 1) / 3, subset = train)
predict(z, Iris[-train, ])$class
(z1 <- update(z, . ~ . - Petal.W.))

}
\references{
Chojecki, A., et al. (2025).
\emph{Learning Permutation Symmetry of a Gaussian Vector with gips in R}.
Journal of Statistical Software, \strong{112}(7), 1--38.
\doi{10.18637/jss.v112.i07}
}
\seealso{
\code{\link[MASS]{lda}},
\code{\link[gips]{gips}}
}
\keyword{multivariate}
