% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_stream.R
\docType{data}
\name{geom_stream}
\alias{geom_stream}
\alias{stat_stream}
\alias{StatStream}
\alias{GeomStream}
\title{Create a Streamline Plot Layer in ggplot2}
\usage{
geom_stream(
  mapping = NULL,
  data = NULL,
  stat = StatStream,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  arrow.fill = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = grid::arrow(angle = 25, length = unit(0.025, "npc"), type = "closed")
)

stat_stream(
  mapping = NULL,
  data = NULL,
  geom = GeomStream,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  arrow.fill = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = grid::arrow(angle = 25, length = unit(0.025, "npc"), type = "closed")
)
}
\arguments{
\item{mapping}{A set of aesthetic mappings created by \code{ggplot2::aes()}.
\strong{Required:} Must include \strong{\code{x}}, \strong{\code{y}}, and \strong{\code{t}}; additionally,
\strong{\code{group}} is used to differentiate streams (if not provided, \code{id} will be mapped to
\code{group} automatically).}

\item{data}{A data frame or other object, as in \code{grid::layer()}.}

\item{stat}{The statistical transformation to use on the data for this layer;
defaults to \link{StatStream}.}

\item{position}{Position adjustment, either as a string or the result of a
position adjustment function.}

\item{...}{Other arguments passed to the underlying layers for further
customization.}

\item{na.rm}{Logical. If \code{FALSE} (the default), missing values are removed
with a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{inherit.aes}{Logical. If \code{FALSE}, overrides the default aesthetics
rather than combining with them.}

\item{arrow.fill}{An optional parameter specifying the color of the arrow
head. Defaults to \code{NULL} and inherets fill/alpha of \code{aes()}.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{arrow}{An optional \code{\link[grid:arrow]{grid::arrow()}} specification to place arrowheads on
the streamline.}

\item{geom}{The geometric object used to render the streamline (only used in
\code{stat_stream()}; defaults to \link{GeomStream}).}
}
\value{
A ggplot2 layer that can be added to a plot to produce a streamline
visualization.
}
\description{
\code{geom_stream()} generates a ggplot2 layer that visualizes data as continuous
streams over a temporal variable \strong{\code{t}}. Each stream is defined by the
required aesthetics \strong{\code{x}}, \strong{\code{y}}, and \strong{\code{t}}, and optionally grouped by
\strong{\code{group}} (or mapped from \code{id}). Within each group, data points are
automatically ordered by \code{t} to form a continuous path.
}
\details{
There are two variants:
\itemize{
\item \code{geom_stream()}: A convenient wrapper that sets \code{stat = StatStream} and uses
\link[ggplot2:ggplot2-ggproto]{ggplot2::GeomPath} by default.
\item \code{stat_stream()}: Provides direct access to the reordering stat (i.e. \code{StatStream})
for advanced customization, using \link{GeomStream} for drawing.
}
}
\section{Aesthetics}{
 \code{geom_stream()} and \code{stat_stream()} understand the
following aesthetics (required aesthetics are in \strong{bold}):
\itemize{
\item \strong{\code{x}}: Horizontal position.
\item \strong{\code{y}}: Vertical position.
\item \strong{\code{t}}: Temporal or ordered variable used to sequence data points.
\item \code{group}: Grouping variable for multiple streams (automatically mapped from \code{id} if absent).
\item \code{color}: Color of the stream.
\item \code{linetype}: Type of line used to draw the stream.
\item \code{linewidth}: Thickness of the stream line.
\item \code{alpha}: Transparency of the stream.
}
}

\section{Details}{

\itemize{
\item \strong{Data Ordering}: If \code{t} is not provided, an error is thrown. When present,
points within each group are sorted by \code{t} prior to drawing the stream.
\item \strong{Arrows}: The \code{arrow} parameter can be used to indicate direction along each stream.
}
}

\section{Computed Variables}{


These are calculated by the 'stat' part of layers and can be accessed with
delayed evaluation.

\describe{
\item{norm}{This variable is calculated as the Euclidean distance derived
from the ranges of the \code{x} and \code{y} values. It serves as a
normalization factor for vector lengths when the \code{normalize}
parameter is active.}

\item{avg_spd}{Represents the average speed, which is defined as the length
of the stream divided by the time it took to traverse that distance.}
}
}

\examples{

n <- 25
s <- seq(0, 1, length.out = n+1)[-(n+1)]
df <- data.frame( "t" = s, "x" = cos(2*pi*s), "y" = sin(2*pi*s) )

ggplot(df) +
  geom_stream(aes(x, y, t = t)) +
  coord_equal()

ggplot(df) +
  geom_stream(aes(x, y, t = t, alpha = t), size = 5) +
  coord_equal()

ggplot(df) +
  geom_path(aes(x, y, alpha = t), size = 5) +
  coord_equal()


stream_1 <- data.frame(
  x = c(0, 3),
  y = c(0, 0),
  t = 0:1
)

stream_2 <- data.frame(
  x = c(1, 1),
  y = c(1, 5),
  t = 0:1
)

stream_3 <- data.frame(
  x = c(2, 5),
  y = c(2, 6),
  t = 0:1
)

streams <- rbind(
  cbind(stream_1, id = 1),
  cbind(stream_2, id = 2),
  cbind(stream_3, id = 3)
)

ggplot(stream_1) +
  geom_stream(aes(x = x, y = y, t = t))

# set group aes if multiple vectors
ggplot(streams) +
  geom_stream(aes(x = x, y = y, t = t, group = id))

}
\keyword{datasets}
