% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vcf.R
\name{read_vcf}
\alias{read_vcf}
\title{Read a VCF file into a tidy variant data frame}
\usage{
read_vcf(path, samples = NULL, pass_only = TRUE, info_fields = NULL)
}
\arguments{
\item{path}{Path to a \code{.vcf} or \code{.vcf.gz} file.}

\item{samples}{Character vector of sample names to retain. \code{NULL} (default)
keeps all samples.}

\item{pass_only}{Logical. If \code{TRUE} (default), only variants with \code{FILTER}
equal to \code{"PASS"} or \code{"."} are retained.}

\item{info_fields}{Character vector of INFO field names to expand into
columns. \code{NULL} keeps none. Use \code{"all"} to expand everything (may be slow
for large files).}
}
\value{
A \code{gvf} (genomic variant frame) — a \code{data.frame} with columns:
\describe{
\item{chrom}{Chromosome (character)}
\item{pos}{Position (integer)}
\item{ref}{Reference allele}
\item{alt}{Alternate allele (multi-allelic sites are split into rows)}
\item{qual}{QUAL score (numeric)}
\item{filter}{FILTER field}
\item{sample}{Sample name (NA for single-sample VCFs without GT field)}
\item{consequence}{Variant consequence if ANN/CSQ INFO field is present}
\item{gene}{Gene symbol if ANN/CSQ INFO field is present}
}
}
\description{
Parses a standard VCF (v4.x) file and returns a tidy \code{data.frame} (a
\code{gvf} object) that all \code{ggvariant} plotting functions accept. For users
who already have variant data in a plain \code{data.frame} or \code{tibble}, see
\code{\link[=coerce_variants]{coerce_variants()}}.
}
\examples{
vcf_file <- system.file("extdata", "example.vcf", package = "ggvariant")
variants <- read_vcf(vcf_file)
head(variants)

}
\seealso{
\code{\link[=coerce_variants]{coerce_variants()}}, \code{\link[=plot_lollipop]{plot_lollipop()}}, \code{\link[=plot_consequence_summary]{plot_consequence_summary()}}
}
