% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-brain.R
\name{scale_continous_brain}
\alias{scale_continous_brain}
\alias{scale_x_brain}
\alias{scale_y_brain}
\alias{scale_labs_brain}
\title{Axis and label scales for brain atlas plots}
\usage{
scale_continous_brain(
  atlas = dk(),
  position = "dispersed",
  aesthetics = c("y", "x")
)

scale_x_brain(...)

scale_y_brain(...)

scale_labs_brain(atlas = dk(), position = "dispersed", aesthetics = "labs")
}
\arguments{
\item{atlas}{A `ggseg_atlas` object or data.frame containing atlas data.}

\item{position}{Layout style: `"dispersed"` (default) or `"stacked"`.}

\item{aesthetics}{Which axis to scale: `"x"`, `"y"`, or `"labs"`.}

\item{...}{Additional arguments passed to [adapt_scales()].}
}
\value{
A ggplot2 scale or labs object.
}
\description{
Add axis labels and tick labels corresponding to brain atlas regions.
These scales add hemisphere or view labels to the x and y axes based on
the atlas layout.
}
\examples{
\donttest{
library(ggplot2)

ggplot() +
  geom_brain(atlas = dk()) +
  scale_x_brain() +
  scale_y_brain() +
  scale_labs_brain()
}

}
