% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-fm.R
\name{swap_xy}
\alias{swap_xy}
\title{Swap x and y in a formula}
\usage{
swap_xy(f, backwards = FALSE)
}
\arguments{
\item{f}{formula An R model formula}

\item{backwards}{logical}
}
\value{
A copy of \code{f} with \code{x} and \code{y} swapped by each other
  in the lhs and rhs.
}
\description{
By default a formula of x on y is converted into a formula of y
on x, while the reverse swap is done only if \code{backward = TRUE}.
}
\details{
This function is meant to be used only as a helper within 'ggplot2'
statistics. Normally together with geometries supporting orientation when
we want to automate the change in orientation based on a user-supplied
formula. Only \code{x} and \code{y} are changed, and in other respects
the formula is rebuilt copying the environment from \code{f}.
}
