% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_annotation.R
\name{pathway_annotation}
\alias{pathway_annotation}
\title{Pathway information annotation}
\usage{
pathway_annotation(
  file = NULL,
  pathway = NULL,
  daa_results_df = NULL,
  ko_to_kegg = FALSE,
  organism = NULL,
  p_adjust_threshold = 0.05
)
}
\arguments{
\item{file}{A character string, the path to the PICRUSt2 output file.}

\item{pathway}{A character string, the type of pathway to annotate. Options are "KO", "EC", or "MetaCyc".}

\item{daa_results_df}{A data frame, the output from `pathway_daa` function. When `ko_to_kegg = TRUE`,
must contain columns: feature, p_values, p_adjust, and method.}

\item{ko_to_kegg}{A logical, decide if convert KO abundance to KEGG pathway abundance. Default is FALSE.
Set to TRUE when using the function for the second use case. When TRUE, queries KEGG database for
pathway annotations (requires internet connection) and filters for significant pathways.}

\item{organism}{A character string specifying the KEGG organism code (e.g., 'hsa' for human, 'eco' for E. coli).
Default is NULL, which retrieves generic KO information not specific to any organism. Only used when ko_to_kegg is TRUE.}

\item{p_adjust_threshold}{A numeric value specifying the significance threshold for filtering
pathways when `ko_to_kegg = TRUE`. Only pathways with `p_adjust < p_adjust_threshold` will be
annotated via KEGG API. Default is 0.05. Ignored when `ko_to_kegg = FALSE`.}
}
\value{
A data frame with annotated pathway information.

If using the function for the first use case (file input), the output data frame will include:
\itemize{
  \item \code{id}: The pathway ID.
  \item \code{description}: The description of the pathway.
  \item \code{sample1, sample2, ...}: Abundance values for each sample.
}

If \code{ko_to_kegg} is set to TRUE, the output data frame will also include:
\itemize{
  \item \code{pathway_name}: The name of the KEGG pathway.
  \item \code{pathway_description}: The description of the KEGG pathway.
  \item \code{pathway_class}: The class of the KEGG pathway.
  \item \code{pathway_map}: The KEGG pathway map ID.
}

**Note**: When \code{ko_to_kegg = TRUE}, only pathways with
\code{p_adjust < p_adjust_threshold} are processed. If no pathways meet this criterion,
all annotation columns will be NA, and a detailed warning message will be issued with
diagnostic information.

When \code{ko_to_kegg} is TRUE, the function queries the KEGG database for pathway information.
By default (organism = NULL), it retrieves generic KO information that is not specific to any organism.
If you are interested in organism-specific pathway information, you can specify the KEGG organism code
using the \code{organism} parameter.
}
\description{
This function serves two main purposes:
1. Annotating pathway information from PICRUSt2 output files.
2. Annotating pathway information from the output of `pathway_daa` function, and converting KO abundance to KEGG pathway abundance when `ko_to_kegg` is set to TRUE.

**Important**: When `ko_to_kegg = TRUE`, this function automatically filters pathways by
`p_adjust < p_adjust_threshold`. If no pathways meet this criterion, the function returns
the original data with NA annotation columns and issues a detailed warning message with
diagnostic information and recommendations.
}
\examples{
\dontrun{
# Example 1: Annotate pathways from PICRUSt2 output file
pathway_annotation(file = "path/to/picrust2_output.tsv",
                              pathway = "KO")
}

\dontrun{
# Example 2: Annotate pathways from pathway_daa output
# Assuming you have daa_results from pathway_daa function
daa_results <- pathway_daa(abundance, metadata, group = "Group")
annotated_results <- pathway_annotation(pathway = "KO",
                              daa_results_df = daa_results,
                              ko_to_kegg = FALSE)
}
}
