% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_daa_results.R
\name{compare_daa_results}
\alias{compare_daa_results}
\title{Compare the Consistency of Statistically Significant Features}
\arguments{
\item{daa_results_list}{A list of data frames containing statistically significant features obtained using different methods.}

\item{method_names}{A character vector of names for each method used.}

\item{p_values_threshold}{A numeric value representing the threshold for the p-values. Features with p-values less than this
threshold are considered statistically significant. Default is 0.05.}
}
\value{
A data frame with the comparison results. The data frame has the following columns:
\itemize{
  \item \code{method}: The name of the method.
  \item \code{num_features}: The total number of statistically significant features obtained by the method.
  \item \code{num_common_features}: The number of features that are common to other methods.
  \item \code{num_diff_features}: The number of features that are different from other methods.
  \item \code{common_features}: The names of the features that are common to all methods.
  \item \code{diff_features}: The names of the features that are different from other methods.
}
}
\description{
This function compares the consistency and inconsistency of statistically significant features obtained
using different methods in `pathway_daa` from the `ggpicrust2` package. It creates a report showing the number of common and
different features identified by each method, and the features themselves.
}
\examples{
# Minimal DAA-like results from three methods (no external dependencies required)
deseq2_df <- data.frame(
  feature = c("ko00010", "ko00020", "ko00564"),
  group1 = c("A", "A", "A"),
  group2 = c("B", "B", "B"),
  p_adjust = c(0.01, 0.20, 0.03),
  stringsAsFactors = FALSE
)

edgeR_df <- data.frame(
  feature = c("ko00010", "ko00680", "ko00564"),
  group1 = c("A", "A", "A"),
  group2 = c("B", "B", "B"),
  p_adjust = c(0.02, 0.04, 0.01),
  stringsAsFactors = FALSE
)

maaslin2_df <- data.frame(
  feature = c("ko00010", "ko03030", "ko00564"),
  group1 = c("A", "A", "A"),
  group2 = c("B", "B", "B"),
  p_adjust = c(0.03, 0.02, 0.04),
  stringsAsFactors = FALSE
)

daa_results_list <- list(DESeq2 = deseq2_df, edgeR = edgeR_df, Maaslin2 = maaslin2_df)
comparison_results <- compare_daa_results(
  daa_results_list = daa_results_list,
  method_names = c("DESeq2", "edgeR", "Maaslin2"),
  p_values_threshold = 0.05
)
comparison_results
}
