% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cowplot_helpers.R
\name{get_legend}
\alias{get_legend}
\title{Extract Legend from a ggplot}
\usage{
get_legend(plot)
}
\arguments{
\item{plot}{A ggplot object.}
}
\value{
A grob containing the legend, or \code{NULL} if the plot has no
legend.
}
\description{
Extracts the legend (guide-box) from a ggplot object as a grob that can be
used independently with grid or cowplot.
}
\details{
This function is useful for cowplot workflows where you want to manually
position a shared legend. The extracted legend can be combined with plots
using \code{cowplot::plot_grid()} or drawn directly with
\code{grid::grid.draw()}.
}
\examples{
library(ggplot2)

p <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
  geom_point() +
  labs(color = "Cylinders")

# Extract the legend
leg <- get_legend(p)

# Draw just the legend
grid::grid.newpage()
grid::grid.draw(leg)

}
\seealso{
\code{\link{shared_legend}}, \code{\link{collect_legends}}
}
