% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_scatterMatrix.R
\name{ggInterval_scatterMatrix}
\alias{ggInterval_scatterMatrix}
\title{scatter plot for all variable by interval data.}
\usage{
ggInterval_scatterMatrix(data = NULL,mapping = aes(NULL), showLegend=FALSE)
}
\arguments{
\item{data}{A ggInterval object. It can also be either RSDA object or
classical data frame,which will be automatically convert to ggInterval
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.}

\item{showLegend}{whether show the legend.}
}
\value{
Return a plot with no longer a ggplot2 object,instead
of a marrangeGrob object.
}
\description{
Visualize the all continuous variable distribution
by rectangle for both x-axis and y-axis with a matrix grid.
Note: this function will automatically
filter out the discrete variables,and plot all continuous in
input data,so it can not be necessary that give the particularly
variables in aes such like (aes(x = x, y = y)). It isn't also
recommended to deal with too many variables because the
big O in calculating full matrix will be too large.
}
\examples{
a<-rnorm(1000,0,5)
b<-runif(1000,-20,-10)
c<-rgamma(1000,10,5)
d<-as.data.frame(cbind(norm=a,unif=b,gamma_10_5=c))
ggInterval_scatterMatrix(d)


ggInterval_scatterMatrix(mtcars[,c("mpg","wt","qsec")],
    aes(col="red",lty=2,fill="blue",alpha=0.3))


myIris <- classic2sym(iris,groupby = "Species")$intervalData
ggInterval_scatterMatrix(myIris[,1:3])


mydata <- ggInterval::Cardiological
ggInterval_scatterMatrix(mydata[,1:3],aes(fill="black",alpha=0.2))
}
