% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_boxplot.R
\name{ggInterval_boxplot}
\alias{ggInterval_boxplot}
\title{A interval Box plot}
\usage{
ggInterval_boxplot(data = NULL,mapping = aes(NULL),plotAll=FALSE)
}
\arguments{
\item{data}{A ggInterval object. It can also be either RSDA object or
classical data frame, which will be automatically convert to ggInterval
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.
It is the same as the mapping of ggplot2.}

\item{plotAll}{booleans, if TRUE, plot all variable together}
}
\value{
Return a ggplot2 object.
}
\description{
Visualize the one continuous variable distribution
by box represented by multiple rectangles.
}
\examples{
p<-ggInterval_boxplot(iris,aes(iris$Petal.Length))
p
p+scale_fill_manual(values = c("red","yellow",
    "green","blue","black"),
    labels=c("0\%","25\%","50\%","75\%","100\%"),
    name="quantile")

mydata<-ggInterval::facedata
ggInterval_boxplot(mydata,aes(AD,col="black",alpha=0.5))

myMtcars<-classic2sym(mtcars)
myMtcars<-myMtcars$intervalData
ggInterval_boxplot(myMtcars,aes(disp))

}
