#' Preparer of main references for automatic insertion in scientific articles
#'
#' The article_bibextra function prepares the metadata of the main scientific references to be automatically included in a scientific article. Initially, the user obtains the list of main references indicated and enters them into the standardized tabarticle_extra spreadsheet. The article_bibextra function internally calls the gerard_lister and bibtex_lister functions. The gerard_lister function separates and organizes the metadata of each article in the list selected by the user and stores it in a dataframe. The bibtex_lister function is then applied to the set of metadata organized in the dataframe and converts it to BibTex format. The output of the article_bibextra function is a file with the .bib extension, containing the list of references in BibTex format, prepared to be automatically included in the reference list of a scientific article.
#'
#' @param input_date is a dataframe with the scientific production database obtained of colection WoS, Scopus and others
#' @param input_tam is the length of the dataframe with the main scientifics articles, obtained using package bibliorefer.

#' @return This function returns a file with the .bib extension, containing the list of references in bibtex format, prepared to be automatically included in the reference list of a scientific paper.
#' @importFrom utils read.csv2
#' @importFrom bibliorefer ajust_pagin principal_lister
#' @export
#'
#' @references
#' 1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
#' 2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
#'
#' @examples
#'
#' # Example 1
#'
#' # File of database
#' file_db <- system.file("extdata","database_articleextra.csv", package = "gerefer")
#'
#' input_date <- example_database2(file_db)
#' input_tam <- 8

#'
#' #Calls the function article_bib
#' lister_bibtex <- article_bibextra(input_date, input_tam)
#' lister_bibtex
#'


article_bibextra <- function(input_date,input_tam){

  # Entrada de dados
  # Data entry
  input_date <- input_date
  input_tam <- input_tam

  # Call the function
  gerad_articleextra <- function(input_date){

    # Replace dataframe with matrix
    input_entrada <- as.matrix(input_date)

    # Delete NA
    na_retir <- function(input_entr){

      # Data entry
      entrada_base <- input_entr
      entrada_base <- as.data.frame(entrada_base)
      colnames(entrada_base) <- "base"

      # Delete NA
      variavel <- entrada_base$base
      testena <- is.na(variavel)
      padrao <- "TRUE"
      linha_na <- grep(padrao,testena)
      variavel[linha_na] <- ""

      return(variavel)

    }

    # Create the loop indexer
    nomes_colunas <- names(input_date)

    # Create the loop along the columns
    for (i in seq_along(nomes_colunas)){

      input_entr <- nomes_colunas[i]
      names(input_entrada) <- colnames(input_date)
      coluna <- na_retir(input_entrada[,input_entr])
      input_entrada[,i] <- coluna

    }

    # Change format from matrix to dataframe
    tabela <- input_entrada
    tabela <- as.data.frame(input_entrada)
    ##

    # Create the extra table
    n <- length(tabela$autor)
    citacoes <- 1:n
    link <- rep("",n)
    abstract <- rep("",n)
    paginas <- rep("",n)
    volume <- rep("",n)
    extra <- cbind(volume,link,abstract,citacoes)
    extra <- as.data.frame(extra)

    # Create the input table and change the names
    nomes <- c("AU","TI", "edicao", "local", "SO", "PY", "PP",
               "VL","DI","AB","TC")
    baseentrada <- cbind(tabela, extra)
    colnames(baseentrada) <- nomes

    # Call the main list function
    input_dateprin <- baseentrada
    input_tam <- n
    listaprincipal <- principal_lister(input_dateprin,input_tam)
    lista_prin <- listaprincipal[[1]]
    posicao_book <- lista_prin$Article
    posicao_info <- which(posicao_book != "")
    ##

    # Calculating the size of tables
    tamanho <- length(posicao_info)

    # Create the input table and change the name
    tabela_book <- tabela

    nomes_tabela <- c("autor", "titulo", "revista", "volume", "pagina",
                      "ano", "link", "acesso")
    colnames(tabela_book) <- nomes_tabela
    ####

    # Create the year author identity
    # Separate team authors
    autsep_book <- strsplit(tabela_book$autor, split = "; ")

    # Create storage vectors
    prim_aut <- numeric(tamanho)
    primei_aut <- numeric(tamanho)
    primei_auto <- numeric(tamanho)
    primei_autor <- numeric(tamanho)
    autor_ano <- numeric(tamanho)
    tamanho_aut <- numeric(tamanho)

    # Create the loop to generate the author year identity
    for(i in 1:tamanho){

      prim_aut[i] <- autsep_book[[i]][1]
      primei_aut[i] <- strsplit(prim_aut[[i]][1],split = ",")
      primei_auto[i] <- primei_aut[[i]][1]
      primei_autor[i] <- strsplit(primei_auto[[i]][1],split = " ")
      tamanho_aut[i] <- length(primei_autor[[i]])
      tamanho_auttest <- tamanho_aut[i]
    }

    # Create the loop to generate the author year identity
    for(i in 1:tamanho){

      prim_aut[i] <- autsep_book[[i]][1]
      primei_aut[i] <- strsplit(prim_aut[[i]][1],split = ",")
      primei_auto[i] <- primei_aut[[i]][1]
      primei_autor[i] <- strsplit(primei_auto[[i]][1],split = " ")
      tamanho_aut[i] <- length(primei_autor[[i]])
      tamanho_auttest <- tamanho_aut[i]

      # Standardize the page separator
      if(tamanho_auttest < 2){

        autor_ano[i] <- paste0(primei_autor[[i]][1],tabela_book$ano[i])

      }else{

        autor_ano[i] <- paste0(primei_autor[[i]][1],primei_autor[[i]][2],
                               tabela_book$ano[i])
      }

    }

    ###
    # Create variables
    tamanho_autor <- numeric(tamanho)
    equipesnomes <- numeric(tamanho)

    # Create the loop to generate the author year identity
    for(i in 1:tamanho){

      tamanho_autor[i] <- length(autsep_book[[i]])

      if(tamanho_autor[i] <= 1){

        equipesnom <- autsep_book[[i]]

      }else{
        conexao <- " and "
        equipenom <- numeric(tamanho_autor[i])

        # Create team first name
        equipenom[1] <- paste0(autsep_book[[i]][1],conexao)
        equipesnom <- equipenom[1]

        # Create team name sequence
        for(ind in 2:(tamanho_autor[i]-1)) {

          equipenom[ind] <- paste0(equipenom[ind-1],
                                   autsep_book[[i]][ind],conexao)
          equipesnom <- equipenom[ind]
        }

        # Create the last name of the sequence
        equipenom[tamanho_autor[i]] <- paste0(equipenom[tamanho_autor[i]-1],
                                              autsep_book[[i]][tamanho_autor[i]])
        equipesnom <- equipenom[tamanho_autor[i]]

      }
      equipesnomes[i] <- equipesnom
    }
    ##

    tamanho_subti <- numeric(tamanho)
    titul_artic <- numeric(tamanho)
    subtitul_artic <- numeric(tamanho)

    # Call the function from the authors name
    titulo_minu <- function(enti_artic){

      # Data entry
      tit_arti <- enti_artic

      # Change the letter to lowercase
      titu_minu <- tolower(tit_arti)

      # Separate words
      let_minu <- strsplit(titu_minu," ")

      # Select first letter of words
      prl_min <- let_minu[[1]][1]

      # Separar letra da primeira palavra
      prl_minsep <- strsplit(prl_min, "")

      # Selecionar a primeira letra minúscula
      prl_minu <- prl_minsep[[1]][1]

      #"‘"=2018
      padrao_aspa1 <- "\u2018"
      test_aspa1 <- grepl(padrao_aspa1, prl_minu)

      #"“"=201C
      padrao_aspa2 <- "\u201C"
      test_aspa2 <- grepl(padrao_aspa2, prl_minu)

      #"'"=0027
      padrao_aspavert1 <- "\u0027"
      test_aspavert1 <- grepl(padrao_aspavert1, prl_minu)

      #"`"=0060
      padrao_apost1 <- "\u0060"
      test_apost1 <- grepl(padrao_apost1, prl_minu)

      #"\""="\0022"
      padrao_apost2 <- "\u0022"
      test_apost2 <- grepl(padrao_apost2, prl_minu)

      #"\\("=0028
      padrao_paren <- "\\u0028"
      test_paren <- grepl(padrao_paren, prl_minu)

      #"#"=0023
      padrao_hash <- "\u0023"
      test_hash <- grepl(padrao_hash, prl_minu)

      if(test_aspa1 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_aspa2 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_apost1 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_apost2 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_aspavert1 == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_paren == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else if(test_hash == TRUE){

        prl_minu <- prl_minsep[[1]][2]

      }else{

        prl_minu <- prl_minsep[[1]][1]

      }

      # Capitalize the first letter
      prl_maiu <- toupper(prl_minu)

      # Replace the lowercase letter with the uppercase letter
      tit_artic <- sub(prl_minu,prl_maiu,titu_minu)

      # Return the author's name
      return(tit_artic)

    }

    titu_art <- tabela_book$titulo
    entitu_artic <- titu_art

    for(i in 1:tamanho){

      enti_artic <- entitu_artic[i]

      # Return the author's name
      padrao_pont <- ":"
      padrao_pont1 <- ":"
      test_subtitu <- grepl(padrao_pont,enti_artic)

      padrao_true <- "TRUE"
      linha_sub <- grep(padrao_true,test_subtitu)
      tamanho_titul <- length(linha_sub)

      # Standardize the page separator
      if(test_subtitu == FALSE){

        titu_artic <- enti_artic
        titu_artic <- titulo_minu(titu_artic)
        subtitu_artic <- ""

      }else{

        titulo_basesepar <- strsplit(enti_artic,
                                     split = padrao_pont)
        comp_subti <- length(titulo_basesepar[[1]])

        if(comp_subti == 2){

          titu_artic <- paste0(titulo_basesepar[[1]][1],padrao_pont1)
          titu_artic <- titulo_minu(titu_artic)
          subtitu_artic <- titulo_basesepar[[1]][2]
          subtitu_artic <- tolower(subtitu_artic)

        }else{

          titu_artic <- paste0(titulo_basesepar[[1]][1],padrao_pont1)
          titu_artic <- titulo_minu(titu_artic)
          subtitu_artic <- titulo_basesepar[[1]][2]

          for(k in 3:comp_subti){

            subtitu_artic <- paste0(subtitu_artic, sep = ".",
                                    titulo_basesepar[[1]][k])
            subtitu_artic <- tolower(subtitu_artic)
          }

        }

      }

      titul_artic[i] <- titu_artic
      subtitul_artic[i] <- subtitu_artic

    }

    ###

    # Function that changes the title to lowercase
    # Calculate variable sizes
    journal_maius <- numeric(n)
    jornais <- numeric(n)
    # Create new variable for titles
    jornal_art <- tabela_book$revista
    journal_art <- jornal_art

    # Create the loop
    for(i in 1:n){

      # Input with capital letter
      entrada_journal <- journal_art[i]

      if(entrada_journal == ""){

        jour  <- ""

      }else{

        # Entry indexed with capital letter
        journal_maius[i] <- entrada_journal

        # Change the format to lowercase
        journal_minu <- tolower(entrada_journal)

        # Separate words
        journal_separ <- strsplit(journal_minu," ")

        # Select first word
        primei_palajour <- journal_separ[[1]][1]

        # Separate letters from words
        pljour <- strsplit(primei_palajour,"")

        # Select first letter of words
        primeira_palajour <- pljour[[1]][1]

        # Capitalize the first letter
        primeira_maiujour <- toupper(primeira_palajour)

        # Replace the lowercase letter with the uppercase letter
        jour <- sub(primeira_palajour,primeira_maiujour,journal_minu)

      }

      # Create indexed variable
      jornais[i] <- jour
    }
    ###

    # Criar o teste para o volume
    # Create the test for the volume
    tabela_bookvolumes <- numeric(tamanho)
    teste_volumena <- is.na(tabela_book$volume)
    teste_volumevazio <- tabela_book$volume == ""

    # Criar o laço para o volume
    # Create the loop for the volume
    for(i in 1:tamanho){

      # Standardize the page separator
      if(teste_volumena[i] == FALSE && teste_volumevazio[i] == FALSE){

        tabela_bookvolume <- tabela_book$volume[i]

      }else if(teste_volumena[i] == TRUE){

        tabela_bookvolume <- ""

      }else {

        tabela_bookvolume <- ""

      }

      tabela_bookvolumes[i] <- tabela_bookvolume
    }

    ##
    # Organização das páginas
    # Organization of pages
    saida_pagina <- numeric(tamanho)
    entrada_pagina <- tabela_book$pagina

    pagina_refer <- function(entrada_pagina){

      entrada_pagina <- entrada_pagina

      pagina_refe <- function(entrada_pagina){

        # Check lines with page separation pattern
        hifsesp <- "\u002D"
        hifcesp <- " \u002D "
        linhas_hifsesp <- grepl(hifsesp,entrada_pagina)
        linhas_hifcesp <- grepl(hifcesp,entrada_pagina)

        mriscsesp <- "\u2013"
        mrisccesp <- " \u2013 "
        linhas_mriscsesp <- grepl(mriscsesp,entrada_pagina)
        linhas_mrisccesp <- grepl(mrisccesp,entrada_pagina)

        if(linhas_hifsesp == TRUE && linhas_hifcesp == FALSE){
          hifensesp <- "\u002D"
          pagin_liv <- strsplit(entrada_pagina,
                                split = hifensesp)
          traco1 <- "\u002D"
          traco2 <- "\u002D"
          tracom2 <- paste0(traco1,traco2)
          saida_pagin <- paste0(pagin_liv[[1]][1],tracom2,
                                pagin_liv[[1]][2])

        }else if(linhas_hifsesp == TRUE && linhas_hifcesp == TRUE){
          hifencesp <- " \u002D "
          pagin_liv <- strsplit(entrada_pagina,
                                split = hifencesp)
          traco1 <- "\u002D"
          traco2 <- "\u002D"
          tracom2 <- paste0(traco1,traco2)
          saida_pagin <- paste0(pagin_liv[[1]][1],tracom2,
                                pagin_liv[[1]][2])

        }else if(linhas_mriscsesp == TRUE && linhas_mrisccesp == FALSE){

          mriscsesp <- "\u2013"
          pagin_liv <- strsplit(entrada_pagina,
                                split = mriscsesp)
          traco1 <- "\u002D"
          traco2 <- "\u002D"
          tracom22 <- paste0(traco1,traco2)
          saida_pagin <- paste0(pagin_liv[[1]][1],tracom22,
                                pagin_liv[[1]][2])
        } else {

          mriscsesp <- " \u2013 "
          pagin_liv <- strsplit(entrada_pagina,
                                split = mrisccesp)
          traco1 <- "\u002D"
          traco2 <- "\u002D"
          tracom22 <- paste0(traco1,traco2)
          saida_pagin <- paste0(pagin_liv[[1]][1],tracom22,
                                pagin_liv[[1]][2])
        }

        return(saida_pagin)
      }

      for(i in 1:tamanho){

        entrada_pagina <- tabela_book$pagina[i]

        if(entrada_pagina == ""){

          saida_pagin <- ""

        }else{

          saida_pagin <- pagina_refe(entrada_pagina)

        }

        saida_pagina[i] <- saida_pagin

      }

      return(saida_pagina)

    }

    ##
    # Call the access date function
    acesso_datas <- function(input_dateace){

      # Remove NA
      na_retir <- function(input_entr){

        # Data entry
        entrada_base <- input_entr
        entrada_base <- as.data.frame(entrada_base)
        colnames(entrada_base) <- "base"

        # Remove NA
        variavel <- entrada_base$base
        testena <- is.na(variavel)
        padrao <- "TRUE"
        linha_na <- grep(padrao,testena)
        variavel[linha_na] <- ""

        return(variavel)

      }

      # Call function to remove NA
      input_entr <- input_dateace
      entrada_data <- na_retir(input_entr)

      # Calculate the column size and generate the corresponding vectors
      n <- length(entrada_data)
      data_acessos <- numeric(n)
      dia_acesso <- numeric(n)

      # Create the loop
      for(i in 1:n){

        if(entrada_data[i] == ""){

          dia_acess <- ""

        }else{

          data_sepa <- strsplit(entrada_data, split = "/")
          data_separ <- data_sepa[[i]]

          # Create the day
          ind_dia <- 1
          dia_separ <- data_separ[ind_dia]

          # Create the month
          ind_mes <- 2
          mes_separ <- data_separ[ind_mes]

          # Create the year
          ind_ano <- 3
          ano_sepa <- data_separ[ind_ano]
          inicio_ano <- 20
          ano_separ <- paste0(inicio_ano,ano_sepa)
          ano_separ <- as.numeric(ano_separ)

          # Generate the access date
          hifen <- "\u002D"
          data_acesso <- paste0(ano_separ, hifen, mes_separ, hifen, dia_separ)
          data_acessos[i] <- data_acesso

          dia_acess <- data_acessos[i]

        }

        dia_acesso[i] <- dia_acess

      }

      return(dia_acesso)

    }
    ##

    # Create access dates
    paginas <- pagina_refer(entrada_pagina)
    input_dataacesso <- tabela_book$acesso
    data_acessos <- acesso_datas(input_dataacesso)

    # Create the table with the information of interest and change the format
    tabel_bibtexi <- cbind(autor_ano, equipesnomes, titul_artic, subtitul_artic,
                           jornais, tabela_bookvolumes, paginas, tabela_book$ano,
                           tabela_book$link, data_acessos)
    tabel_bibtexi <- as.data.frame(tabel_bibtexi)

    # Mudar os nomes das colunas
    # Change column names
    nomes <- c("fonte_ano","autores","titulo","subtitulo","revista",
               "volume","paginas","ano","link", "acesso")
    colnames(tabel_bibtexi) <- nomes

    return(tabel_bibtexi)

  }

  # Function that generates the file in bibtex format
  bibtex_lister <- function(tabel_bibtex,indic){

    # Data entry
    input_tabel <- tabel_bibtex
    tabela <- input_tabel
    linha <- indic

    # Reduce database size
    tabela_redu <- tabela[linha,]
    tabela_ent <- tabela_redu
    c("fonte_ano","autores","titulo","subtitulo","revista",
      "volume","paginas","ano","link", "acesso")
    # Assign input information to variables
    simbolo_entrada <- "@article{"
    fonte_ano <- tabela_ent$fonte_ano
    autor <- tabela_ent$autores
    titulo <- tabela_ent$titulo
    subtitulo <- tabela_ent$subtitulo
    revista <- tabela_ent$revista
    volume <- tabela_ent$volume
    pagina <- tabela_ent$paginas
    ano <- tabela_ent$ano
    link <- tabela_ent$link
    acesso <- tabela_ent$acesso

    # Create the elements of the bibtex format structure
    espaco <- "  "
    virgula <- ","
    autorbook <- "author="
    titulobook <- "title="
    subtitulobook <- "subtitle="
    revistabook <- "journal="
    volumebook <- "volume="
    paginabook <- "pages="
    anobook <- "year="
    linkbook <- "url="
    acessobook <- "urldate="

    #publicacaoart <- "publisher="
    chave_entrada <- "{"
    chave_saida <- "}"

    # Create the bibtex structure for each variable
    chave <- paste0(simbolo_entrada,fonte_ano,virgula)
    autor <- paste0(autorbook,chave_entrada,autor,
                    chave_saida)
    titulo <- paste0(titulobook,chave_entrada,titulo,
                     chave_saida)
    subtitulo <- paste0(subtitulobook,chave_entrada,subtitulo,
                        chave_saida)
    revista <- paste0(revistabook,chave_entrada,revista,
                      chave_saida)
    volume <- paste0(volumebook,chave_entrada,volume,
                     chave_saida)
    pagina <- paste0(paginabook,chave_entrada,pagina,
                     chave_saida)
    ano <- paste0(anobook,chave_entrada,ano,
                  chave_saida)
    link <- paste0(linkbook,chave_entrada,link,
                   chave_saida)
    acesso <- paste0(acessobook,chave_entrada,acesso,
                     chave_saida)

    # Create bibtex format for articles
    referen_bibtex <- paste0(chave,"\n",
                             espaco, autor, virgula, "\n",
                             espaco, titulo, virgula, "\n",
                             espaco, subtitulo, virgula, "\n",
                             espaco, revista, virgula, "\n",
                             espaco, volume, virgula, "\n",
                             espaco, pagina, virgula, "\n",
                             espaco, ano, virgula, "\n",
                             espaco, link, virgula, "\n",
                             espaco, acesso, "\n", chave_saida,
                             espaco, collapse = ",\n")

    # Returns the file in bibtex format
    return(referen_bibtex)
  }

  # Create the variable to store values
  arquivo_bibtex <- c()
  n <- input_tam

  # Create the loop to generate the list of bibtex files
  for(i in 1:n){

    # Call the function that converts to bibtex format
    tabel_bibtex <- gerad_articleextra(input_date)

    # Create the parameter linked to the index
    indic <- i

    # Call the function that converts to bibtex format
    refer_bibtex <- bibtex_lister(tabel_bibtex,indic)
    arquivo_bibtex[i] <- refer_bibtex

  }

  # Return the value of the variable
  lista_final <- arquivo_bibtex

  return(lista_final)

}
