% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOConstraints.R
\docType{class}
\name{ISOConstraints}
\alias{ISOConstraints}
\title{ISOConstraints}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO abstract Constraints
}
\description{
ISOConstraints

ISOConstraints
}
\note{
Abstract ISO class
}
\references{
- ISO 19139 \url{https://schemas.isotc211.org/19139/-/gmd/1.0/gmd/#element_MD_Constraints}

  - ISO 19115-3 \url{https://schemas.isotc211.org/19115/-3/mco/1.0/mco/#element_MD_Constraints}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{constraints}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{ISOConstraints}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{useLimitation}}{useLimitation [0..*]: character}

\item{\code{constraintApplicationScope}}{constraintApplicationScope [0..1]: ISOScope (=> ISO 19115-3)}

\item{\code{graphic}}{graphic [0..*]: ISOBrowseGraphic (=> ISO 19115-3)}

\item{\code{reference}}{reference [0..*]: ISOCitation (=> ISO 19115-3)}

\item{\code{releasability}}{releasability [0..1]: ISOReleasability (=> ISO 19115-3)}

\item{\code{responsibleParty}}{responsibleParty [0..*]: ISOAbstractResponsibility (=> ISO 19115-3)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOConstraints-new}{\code{ISOConstraints$new()}}
\item \href{#method-ISOConstraints-addUseLimitation}{\code{ISOConstraints$addUseLimitation()}}
\item \href{#method-ISOConstraints-setUseLimitation}{\code{ISOConstraints$setUseLimitation()}}
\item \href{#method-ISOConstraints-delUseLimitation}{\code{ISOConstraints$delUseLimitation()}}
\item \href{#method-ISOConstraints-setScope}{\code{ISOConstraints$setScope()}}
\item \href{#method-ISOConstraints-addGraphic}{\code{ISOConstraints$addGraphic()}}
\item \href{#method-ISOConstraints-delGraphic}{\code{ISOConstraints$delGraphic()}}
\item \href{#method-ISOConstraints-addReference}{\code{ISOConstraints$addReference()}}
\item \href{#method-ISOConstraints-delReference}{\code{ISOConstraints$delReference()}}
\item \href{#method-ISOConstraints-setReleasability}{\code{ISOConstraints$setReleasability()}}
\item \href{#method-ISOConstraints-addResponsibleParty}{\code{ISOConstraints$addResponsibleParty()}}
\item \href{#method-ISOConstraints-delResponsibleParty}{\code{ISOConstraints$delResponsibleParty()}}
\item \href{#method-ISOConstraints-clone}{\code{ISOConstraints$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$new(xml = NULL, defaults = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}

\item{\code{defaults}}{list of default values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-addUseLimitation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-addUseLimitation}{}}}
\subsection{Method \code{addUseLimitation()}}{
Adds a use limitation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$addUseLimitation(useLimitation, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{useLimitation}}{use limitation}

\item{\code{locales}}{list of localized use limitations. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-setUseLimitation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-setUseLimitation}{}}}
\subsection{Method \code{setUseLimitation()}}{
Adds a use limitation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$setUseLimitation(useLimitation, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{useLimitation}}{use limitation}

\item{\code{locales}}{list of localized use limitations. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-delUseLimitation"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-delUseLimitation}{}}}
\subsection{Method \code{delUseLimitation()}}{
Deletes a use limitation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$delUseLimitation(useLimitation, locales = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{useLimitation}}{use limitation}

\item{\code{locales}}{list of localized use limitations. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-setScope"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-setScope}{}}}
\subsection{Method \code{setScope()}}{
Set scope
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$setScope(scope)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{object of class \link{ISOScope}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-addGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-addGraphic}{}}}
\subsection{Method \code{addGraphic()}}{
Adds a graphic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$addGraphic(graphic)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graphic}}{graphic}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-delGraphic"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-delGraphic}{}}}
\subsection{Method \code{delGraphic()}}{
Deletes a graphic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$delGraphic(graphic)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graphic}}{graphic}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-addReference"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-addReference}{}}}
\subsection{Method \code{addReference()}}{
Adds a reference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$addReference(reference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference}}{reference}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-delReference"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-delReference}{}}}
\subsection{Method \code{delReference()}}{
Deletes a reference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$delReference(reference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference}}{reference}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-setReleasability"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-setReleasability}{}}}
\subsection{Method \code{setReleasability()}}{
Set releasbility
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$setReleasability(releasability)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{releasability}}{object of class \link{ISOReleasability}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-addResponsibleParty"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-addResponsibleParty}{}}}
\subsection{Method \code{addResponsibleParty()}}{
Adds a responsible party
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$addResponsibleParty(party)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{party}}{party object of class inheriting \link{ISOAbstractResponsibility}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-delResponsibleParty"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-delResponsibleParty}{}}}
\subsection{Method \code{delResponsibleParty()}}{
Deletes a responsible party
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$delResponsibleParty(party)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{party}}{party object of class inheriting \link{ISOAbstractResponsibility}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOConstraints-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOConstraints-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOConstraints$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
