% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utmups.R
\name{utmups_fwd}
\alias{utmups_fwd}
\alias{utmups_rev}
\title{Convert coordinates to/from UTM/UPS projection}
\usage{
utmups_fwd(x)

utmups_rev(easting, northing, zone, northp)
}
\arguments{
\item{x}{A two-column matrix or data frame of coordinates (longitude, latitude)
in decimal degrees for forward conversion, or a list with longitude and
latitude components. Can also be a length-2 numeric vector for a single point.}

\item{easting}{Numeric vector of easting values (x coordinates) in meters for
reverse conversion.}

\item{northing}{Numeric vector of northing values (y coordinates) in meters for
reverse conversion.}

\item{zone}{Integer vector of UTM zone numbers (1-60) or 0 for UPS (polar regions).}

\item{northp}{Logical vector indicating hemisphere: TRUE for northern hemisphere,
FALSE for southern hemisphere.}
}
\value{
\itemize{
\item \code{utmups_fwd()}: Data frame with columns:
\itemize{
\item \code{x}: Easting in meters
\item \code{y}: Northing in meters
\item \code{zone}: UTM zone number (1-60) or 0 for UPS
\item \code{northp}: Logical, TRUE for northern hemisphere
\item \code{convergence}: Meridian convergence in degrees (angle between true north and grid north)
\item \code{scale}: Scale factor at the point (dimensionless, typically near 1.0)
\item \code{lon}: Longitude in decimal degrees (echoed from input)
\item \code{lat}: Latitude in decimal degrees (echoed from input)
\item \code{crs}: EPSG code string for the UTM/UPS projection
}
\item \code{utmups_rev()}: Data frame with columns:
\itemize{
\item \code{lon}: Longitude in decimal degrees
\item \code{lat}: Latitude in decimal degrees
\item \code{x}: Easting in meters (echoed from input)
\item \code{y}: Northing in meters (echoed from input)
\item \code{zone}: UTM zone number (echoed from input)
\item \code{northp}: Hemisphere indicator (echoed from input)
\item \code{convergence}: Meridian convergence in degrees
\item \code{scale}: Scale factor at the point
\item \code{crs}: EPSG code string for the UTM/UPS projection
}
}
}
\description{
Convert geographic coordinates (longitude/latitude) to UTM or UPS projected
coordinates, or convert projected coordinates back to geographic coordinates.
}
\details{
The Universal Transverse Mercator (UTM) system divides the Earth into 60
zones, each 6 degrees of longitude wide. For polar regions (latitude > 84°N
or < 80°S), the Universal Polar Stereographic (UPS) system is used instead,
indicated by zone = 0.

Both functions are fully vectorized. Missing values (NA) are not currently
supported.

The convergence angle represents the angle between true north and grid north
at a point. The scale factor represents the ratio of the scale along a line
to the scale on the reference surface (typically very close to 1.0).
}
\examples{
# Single point forward conversion
result <- utmups_fwd(c(147.325, -42.881))
result

# Multiple points
pts <- cbind(lon = c(147, 148, -100, 0),
             lat = c(-42, -43, -42, 0))
utmups_fwd(pts)

# Reverse conversion
utmups_rev(result$x, result$y, result$zone, result$northp)

# Round-trip conversion
fwd <- utmups_fwd(pts)
rev <- utmups_rev(fwd$x, fwd$y, fwd$zone, fwd$northp)
cbind(original = pts, converted = rev[, c("lon", "lat")])

# Polar regions use UPS (zone 0)
polar <- cbind(c(147, 148, -100), c(88, -88, -85))
utmups_fwd(polar)
}
