% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtl2dplot.R
\name{qtl2dplot}
\alias{qtl2dplot}
\title{2D QTL plot}
\usage{
qtl2dplot(
  d,
  chrlen = gap::hg19,
  snp_name = "SNP",
  snp_chr = "Chr",
  snp_pos = "bp",
  gene_chr = "p.chr",
  gene_start = "p.start",
  gene_end = "p.end",
  trait = "p.target.short",
  gene = "p.gene",
  TSS = FALSE,
  cis = "cis",
  value = "log10p",
  plot = TRUE,
  cex.labels = 0.6,
  cex.points = 0.6,
  xlab = "QTL position",
  ylab = "Gene position"
)
}
\arguments{
\item{d}{Data to be used.}

\item{chrlen}{lengths of chromosomes for specific build: hg18, hg19, hg38.}

\item{snp_name}{variant name.}

\item{snp_chr}{variant chromosome.}

\item{snp_pos}{variant position.}

\item{gene_chr}{gene chromosome.}

\item{gene_start}{gene start position.}

\item{gene_end}{gene end position.}

\item{trait}{trait name.}

\item{gene}{gene name.}

\item{TSS}{to use TSS when TRUE.}

\item{cis}{cis variant when TRUE.}

\item{value}{A specific value to show.}

\item{plot}{to plot when TRUE.}

\item{cex.labels}{Axis label extension factor.}

\item{cex.points}{Data point extension factor.}

\item{xlab}{X-axis title.}

\item{ylab}{Y-axis title.}
}
\value{
positional information.
}
\description{
2D QTL plot
}
\details{
This function is both used as its own for a 2d plot and/or generate data for a plotly counterpart.
}
\examples{
\dontrun{
INF <- Sys.getenv("INF")
d <- read.csv(file.path(INF,"work","INF1.merge.cis.vs.trans"),as.is=TRUE)
r <- qtl2dplot(d)
# A qtlClaaifier/qtl2dplot coupling example:
ucsc_modified <- bind_rows(ucsc,APOC,AMY,C4B,HIST,HBA)
pqtls <- select(merged,prot,SNP,log.P.) \%>\%
         mutate(log10p=-log.P.) \%>\%
         left_join(caprion_modified) \%>\%
         select(Gene,SNP,prot,log10p)
posSNP <- select(merged,SNP,Chr,bp)
cis.vs.trans <- qtlClassifier(pqtls,posSNP,ucsc_modified,1e6) \%>\%
                mutate(geneChrom=as.integer(geneChrom),
                       cis=if_else(Type=="cis",TRUE,FALSE))
head(cis.vs.trans)
    Gene             SNP  prot log10p geneChrom geneStart  geneEnd SNPChrom    SNPPos  cis
   YWHAB 8:111907280_A_T 1433B   7.38        20  43530174 43535076        8 111907280 FALSE
     A2M 14:34808001_A_T  A2MG   7.51        12   9220421  9268445       14  34808001 FALSE
    APEH  1:12881809_A_G  ACPH   7.83         3  49711834 49720772        1  12881809 FALSE
     PGD 2:121896327_A_G  6PGD   7.79         1  10459174 10479803        2 121896327 FALSE
SERPINF2  17:1618262_C_T  A2AP  12.59        17   1648289  1657825       17   1618262  TRUE
    PGLS 19:54327869_G_T  6PGL   9.87        19  17622481 17631887       19  54327869 FALSE
qtl2dplot(cis.vs.trans,chrlen=gap::hg19,
          snp_name="SNP",snp_chr="SNPChrom",snp_pos="SNPPos",
          gene_chr="geneChrom",gene_start="geneStart",gene_end="geneEnd",
          trait="prot",gene="Gene",
          TSS=TRUE,cis="cis",plot=TRUE,cex.labels=0.6,cex.points=0.6,
          xlab="pQTL position",ylab="Gene position")
}
}
