% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-glimpse.R
\name{glimpse.data_request}
\alias{glimpse.data_request}
\alias{print.occurrences_glimpse}
\title{Get a glimpse of your data}
\usage{
\method{glimpse}{data_request}(x, ...)

\method{print}{occurrences_glimpse}(x, ...)
}
\arguments{
\item{x}{An object of class \code{data_request}}

\item{...}{Other arguments, currently ignored}
}
\description{
\code{\link[=glimpse]{glimpse()}} is like a transposed version of \code{\link[=print]{print()}}: columns run down the page,
and data runs across. This makes it possible to see every column in a data
frame. It's a little like \code{\link[=str]{str()}} applied to a data frame but it tries to
show you as much data as possible. This implementation is specific
to \code{galah} and is evaluated lazily. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This implementation of \code{\link[=glimpse]{glimpse()}} actually involves changing the API call
sent to the server, then returning a novel object class with it's own
\code{\link[=print]{print()}} method.
}
\examples{
\dontrun{
galah_call() |>
  filter(year >= 2019,
         basisOfRecord == "HumanObservation") |>
  select(year, basisOfRecord, species) |>
  glimpse() |>
  collect()
}
}
