% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_searchdata.R
\name{fw_searchdata}
\alias{fw_searchdata}
\title{To download data from the Freshwaterecology.info database.}
\usage{
fw_searchdata(
  organismgroup,
  taxa_searched = NULL,
  ecoparams = NULL,
  apikey = NULL,
  warn = TRUE,
  seed = 1135,
  secure = TRUE,
  inform = FALSE,
  taxalevel = NULL,
  cachefolder = "cache"
)
}
\arguments{
\item{organismgroup}{\code{string}. The organism group to download from the
platform. The allowed group includes \code{"fi", "mi", "pp", "pb",
  "di","mp"} for fishes, macroinvertebrates, phytoplankton, phytobenthos,
diatoms, and macrophytes, respectively. Multiple groups allowed, such as
\code{'pp', 'di'}.
\itemize{
\item{\code{pp}: Pytoplankton.}
\item{\code{mp}: Macrophytes}
\item{\code{mi}: Macroinvertebrates}
\item{\code{fi}: Fishes}
\item{\code{di}: Diatoms}
\item{\code{pb}: Phytobenthos without diatoms}
}}

\item{taxa_searched}{\code{string} An internal placeholder to accommodate the
standard taxonomic names for invertebrates and phytobenthos from the
database.}

\item{ecoparams}{\code{vector}. Selected traits that should be downloaded for
a particular organism group. Check \code{\link{fw_dbguide}} for the allowed
traits in the database.}

\item{apikey}{\code{string}. The API key is automatically loaded using
the loadapikey() internal function.}

\item{warn}{\code{logical} To show species name warning checks and traits cleaning. Default \code{FALSE}.}

\item{seed}{\code{integer}. An integer to help track the caching of the
access token generated during data collation. If a user wants a new token,
the seed should be changed.}

\item{secure}{\code{logical}. If \code{TRUE}, the User will be prompted to
set the API key in the .Renviron file by running the
\code{\link{fw_setapikey}} function. The User must strictly type in API_KEY
= 'api key', save, close the file and restart the R session or RStudio for
the API_KEY environment to be captured. If \code{FALSE}, then the key will
be entered directly in the API_KEY directly in the fw_token() function.
This method is insecure, since other users can obtain the key from the codes.}

\item{inform}{\code{logical}. This is to indicate if the token has been
successfully generated. Default \code{TRUE}.}

\item{taxalevel}{\code{string} Allowed taxonomic levels at which data can be
retrieved. Default is \code{'species'} but data can also be downloaded at
\code{family}, \code{genus}, and \code{taxagroup} level.}

\item{cachefolder}{\code{string}. The root path were the cached data will be
saved on the user PC. If the path is not provided, the cached information
will be saved in the current working directly.}
}
\value{
List of download species traits, ecological paramaeters or traits.
}
\description{
The function provides seamless access and download of species ecological
parameters, traits, or indicators from the www.freshwaterecology.info
database. The function allows multiple organism groups, including
macroinvertebrates, fish, phytoplankton, phytobenthos, macrophytes, and
diatoms.
}
\details{
Downloading macroinvertebrates data takes a lot of time because the database
has a lot of data, considerably slowing the process. Therefore, the
\code{taxa_searched} parameter is recommended for the user to indicate only
particular traits, family, orders, or taxa group where the species falls.
Also, the phytobenthos requires providing the \code{taxa_searched} to enable a
search for a particular taxon group. The parameter should not be provided for
other organism groups because it will not be used in the data search.
}
\examples{

\dontrun{
dfsearch <- fw_searchdata(organismgroup = 'fi',
                           ecoparams = 'migration', cachefolder = 'cache')
}
}
