% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/futility.R
\name{plotRCDF.pooledArms}
\alias{plotRCDF.pooledArms}
\title{Plot Characteristics of the Estimated Distribution of the Treatment Arm-Pooled Number of Endpoints}
\usage{
plotRCDF.pooledArms(
  eventTimeFrame = NULL,
  eventPPcohort = FALSE,
  target,
  plotTarget = TRUE,
  power.axis = TRUE,
  null.TE = 0,
  power.TE = NULL,
  pRandTx = NULL,
  outDate = NULL,
  eventPriorRate,
  eventPriorWeight,
  xlim = NULL,
  xlab = NULL,
  ylab = NULL,
  power.lab = NULL,
  xPosLegend = 0.67,
  fileDir
)
}
\arguments{
\item{eventTimeFrame}{a time frame within which endpoints are counted, specified in weeks as \code{c(start, end)}. If \code{NULL} (default), then all endpoints are counted.}

\item{eventPPcohort}{a logical value. If \code{TRUE}, only endpoints in the per-protocol cohort are counted. The default value is \code{FALSE}.}

\item{target}{a vector of target numbers of endpoints for reporting of the estimated probability that the total number of endpoints will be \eqn{\ge} \code{target}, with a 95\% credible interval}

\item{plotTarget}{a logical value. If \code{TRUE} (default), target lines are added to the plot; if \code{FALSE}, they are omitted.}

\item{power.axis}{a logical value. If \code{TRUE} (default), then a top axis is added to the plot, showing power to reject \eqn{H_0}: TE \eqn{\le} \code{null.TE} using a 1-sided 0.025-level Wald test if TE = \code{power.TE} throughout the trial.}

\item{null.TE}{a numeric value of treatment efficacy (zero by default) specifying the null hypothesis if \code{power.axis} is \code{TRUE}}

\item{power.TE}{a numeric vector of treatment efficacy levels for which power is shown on the top axis. If \code{power.axis} is \code{FALSE}, then \code{power.TE} is ignored.}

\item{pRandTx}{a numeric value specifying the probability of being randomized into the treatment group. If \code{power.axis} is \code{FALSE}, then \code{pRandTx} is ignored.}

\item{outDate}{an optional character string used to match legacy output filenames created by older versions of the package (e.g., files starting with \code{censorTrial_}). If \code{NULL} (default), a default key is used for storing projection summaries.}

\item{eventPriorRate}{a numeric value of the treatment arm-pooled prior mean incidence rate for the endpoint, expressed as the number of events per person-year at risk}

\item{eventPriorWeight}{a numeric vector in which each value represents a weight (i.e., a separate scenario) assigned to the prior gamma distribution of the treatment arm-pooled event rate at the time when 50\% of the estimated total person-time at risk has been accumulated}

\item{xlim}{a numeric vector of the form \code{c(xmin, xmax)} for the user-specified x-axis limits. If \code{NULL} (default), then the computed range of x-axis values will be used.}

\item{xlab}{a character string for the user-specified x-axis label. If \code{NULL} (default), then the label "Total Number of Infections (n)" will be used.}

\item{ylab}{a character string for the user-specified y-axis label. If \code{NULL} (default), then the label "P( Total Number of Infections >= n ) x 100" will be used.}

\item{power.lab}{a character string for the user-specified power-axis label. If \code{NULL} (default), then the label "Power for TE = \code{power.TE} (x 100)" will be used.}

\item{xPosLegend}{a numeric value in \eqn{[0,1]} (0.67 by default) specifying the x-coordinate for the position of the legend}

\item{fileDir}{a character string specifying a path for the input directory}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Takes the output from the \code{\link{completeTrial.pooledArms}} function and generates a plot describing characteristics of the estimated distribution of the treatment arm-pooled number of endpoints.
}
\examples{
arm <- rep(c("C3","T1","T2"), each=250)
schedule <- rbinom(length(arm), 1, 0.01)
entry <- rpois(length(arm), lambda=60)
entry <- entry - min(entry)
last_visit_dt <- entry + runif(length(arm), min=0, max=80)
event <- rbinom(length(arm), 1, 0.01)
dropout <- rbinom(length(arm), 1, 0.02)
dropout[event==1] <- 0
exit <- rep(NA, length(arm))
exit[event==1] <- last_visit_dt[event==1] + 5
exit[dropout==1] <- last_visit_dt[dropout==1] + 5
followup <- ifelse(event==1 | dropout==1, 0, 1)
interimData <- data.frame(arm=arm, schedule2=schedule, entry=entry, exit=exit,
last_visit_dt=last_visit_dt, event=event, dropout=dropout, complete=0,
followup=followup)

weights <- c(0.2, 0.4, 0.6)
tmpdir <- tempfile('futility_example_'); dir.create(tmpdir)
for (j in 1:length(weights)){
  completeTrial.pooledArms(interimData=interimData, nTrials=50, N=1500, enrollRatePeriod=24,
  eventPriorWeight=weights[j], eventPriorRate=0.06, fuTime=80, visitSchedule=seq(0, 80, by=4),
  visitSchedule2=c(0,seq(from=8,to=80,by=12)), saveDir=tmpdir, randomSeed=9)
}

pdf_file <- file.path(tmpdir, paste0('rcdf_pooled_eventPriorRate=', 0.06, '.pdf'))
pdf(file=pdf_file, width=6, height=5)
plotRCDF.pooledArms(target=c(60,30), power.axis=FALSE, eventPriorRate=0.06,
eventPriorWeight=weights, fileDir=tmpdir)
dev.off()

}
\seealso{
\code{\link{completeTrial.pooledArms}} and \code{\link{plotRCDF.byArm}}
}
