% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowmeans.R
\name{rowmeans}
\alias{rowmeans}
\title{Get Row Means}
\usage{
rowmeans(..., na.rm = FALSE)
}
\arguments{
\item{...}{the variables (unquoted) to be included in the row means}

\item{na.rm}{should the missing values be ignored? default is FALSE}
}
\value{
the row means
}
\description{
Does what \code{rowMeans()} does but without having to cbind the variables. Makes it easier to use
with the tidyverse
}
\examples{

\dontrun{

library(furniture)
library(tidyverse)

data <- data.frame(
  x = sample(c(1,2,3,4), 100, replace=TRUE),
  y = rnorm(100),
  z = rnorm(100)
)

data2 <- data \%>\%
  mutate(y_z_mean = rowmeans(y, z))
data2 <- data \%>\%
  mutate(y_z_mean = rowmeans(y, z, na.rm=TRUE))

}

}
