% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_domain.R
\name{.select_domain}
\alias{.select_domain}
\title{.select_domain}
\usage{
.select_domain(v, v_dom, use0, use1)
}
\arguments{
\item{v}{A list containing two elements: 
\itemize{
  \item v[[1]]: A matrix representing \( v(x) \) with \( d \) columns.
  \item v[[2]]: A matrix representing \( v'(x) \) with \( d \) columns.
}}

\item{v_dom}{A boolean vector indicating the domain for `v0` and `v1`.}

\item{use0}{A boolean value indicating whether to select `v0`. If TRUE, `v0` is selected based on `v_dom`.}

\item{use1}{A boolean value indicating whether to select `v1`. If TRUE, `v1` is selected based on `v_dom`.}
}
\value{
A list containing the selected portions of `v0` and `v1` (if applicable), with dimensions adjusted accordingly.
}
\description{
This function selects the portion of a motif that is free from NA values based on a specified domain. 
It allows for the selection of two matrices, `v0` and `v1`, depending on the boolean flags provided.
}
\details{
Select Domain of a Motif
}
\author{
Marzia Angela Cremona & Francesca Chiaromonte
}
