% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-functions.R
\name{hrf_half_cosine}
\alias{hrf_half_cosine}
\title{Half-cosine HRF}
\usage{
hrf_half_cosine(t, h1 = 1, h2 = 5, h3 = 7, h4 = 7, f1 = 0, f2 = 0)
}
\arguments{
\item{t}{Numeric vector of times (s)}

\item{h1, h2, h3, h4}{Segment durations (s). Must be > 0.}

\item{f1}{Initial dip level (default 0), typically in [-0.2, 0]}

\item{f2}{Undershoot level (default 0), typically in [-0.3, 0]}
}
\value{
Numeric vector same length as t
}
\description{
Segments: 0->f1 (h1), f1->1 (h2), 1->f2 (h3), f2->0 (h4).
Negative f1 gives an initial dip; negative f2 gives an undershoot.
Peak is at t = h1 + h2 (amplitude 1 by construction).
}
\examples{
t <- seq(0, 30, by = 0.1)
y <- hrf_half_cosine(t)
}
