% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{plot.flextable}
\alias{plot.flextable}
\title{Plot a flextable}
\usage{
\method{plot}{flextable}(x, ...)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{...}{additional arguments passed to \code{\link[=gen_grob]{gen_grob()}}.}
}
\description{
plots a flextable as a grid grob object
and display the result in a new graphics window.
'ragg' or 'svglite' or 'ggiraph' graphical device drivers
should be used to ensure a correct rendering.
}
\section{caption}{

It's important to note that captions are not part of the table itself.
This means when exporting a table to PNG or SVG formats (image formats),
the caption won't be included. Captions are intended for document outputs
like Word, HTML, or PDF, where tables are embedded within the document
itself.
}

\examples{
library(gdtools)
library(ragg)
register_liberationsans()
set_flextable_defaults(font.family = "Liberation Sans")
ftab <- as_flextable(cars)

\dontshow{
cap <- ragg::agg_capture(width = 7, height = 6, units = "in", res = 150)
grDevices::dev.control("enable")
}
plot(ftab)
\dontshow{
raster <- cap()
dev.off()
plot(as.raster(raster))
init_flextable_defaults()
}
}
\seealso{
Other flextable print function: 
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()},
\code{\link{wrap_flextable}()}
}
\concept{flextable print function}
