% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_body}
\alias{add_body}
\title{Add body rows with one value per column}
\usage{
add_body(x, top = TRUE, ..., values = NULL)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{top}{should the rows be inserted at the top or the bottom.}

\item{...}{named arguments (names are data colnames) of values
to add. It is important to insert data of the same type as the
original data, otherwise it will be transformed (probably
into strings if you add a \code{character} where a \code{double} is expected).
This makes possible to still format cell contents with the \verb{colformat_*}
functions, for example \code{\link[=colformat_num]{colformat_num()}}.}

\item{values}{a list of name-value pairs of labels or values,
names should be existing col_key values. This argument can be used
instead of \code{...} for programming purpose (If \code{values} is
supplied argument \code{...} is ignored).}
}
\description{
Add new rows to the body where each value maps to a named column,
preserving the original column data types.
Unlike \code{\link[=add_body_row]{add_body_row()}} where labels can span multiple columns,
here each value fills exactly one column.

If some columns are not provided, they will be replaced by
\code{NA} and displayed as empty.
}
\examples{
ft <- flextable(head(iris),
  col_keys = c(
    "Species", "Sepal.Length", "Petal.Length",
    "Sepal.Width", "Petal.Width"
  )
)

ft <- add_body(
  x = ft, Sepal.Length = 1:5,
  Sepal.Width = 1:5 * 2, Petal.Length = 1:5 * 3,
  Petal.Width = 1:5 + 10, Species = "Blah", top = FALSE
)

ft <- theme_booktabs(ft)
ft
}
\seealso{
\code{\link[=flextable]{flextable()}}

Other functions for row and column operations in a flextable: 
\code{\link{add_body_row}()},
\code{\link{add_footer}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_header}()},
\code{\link{add_header_lines}()},
\code{\link{add_header_row}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions for row and column operations in a flextable}
