% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata.R
\name{simdata}
\alias{simdata}
\title{simdata}
\usage{
simdata(
  seed = 123,
  n = 1000,
  dist = "weibull",
  cdist = "exponential",
  cparams = list(rate = 0.1),
  lambdas,
  gammas,
  beta_list,
  cov_means,
  cov_sds,
  trans_list,
  state_names
)
}
\arguments{
\item{seed}{Random seed for reproducibility}

\item{n}{Number of subjects}

\item{dist}{distribution to follow for baseline hazard ("exponential", "weibull", "gompertz")}

\item{cdist}{distribution to follow for censoring distribution ("uniform", "exponential", "weibull")}

\item{cparams}{parameter vector for censoring distribution}

\item{lambdas}{scale parameter of the baseline distribution}

\item{gammas}{shape parameter of the baseline distribution}

\item{beta_list}{a list containing coefficients for the covariates to be generated, each value corresponds to one transition}

\item{cov_means}{mean value of each of the covariates}

\item{cov_sds}{standard deviation of each of the covariates}

\item{trans_list}{transition matrix of the multi-state model based on number of states}

\item{state_names}{states of the multi-state model}
}
\value{
a multi-state dataframe with given number of states, corresponding status and the covariate vector
}
\description{
Simulation of a multi-state model with \eqn{n} no. of states.
}
\details{
This function is used for simulating a multi-state model with \eqn{n} no. of states
and status corresponding to each state along with a number of covariates both continuous or categorical.
}
\examples{
##
msdata_4state <- simdata(seed=123,n=1000,dist="weibull",cdist="exponential",
                 cparams=list(rate = 0.1),lambdas=c(0.1, 0.2, 0.3, 0.4),
                 gammas=c(1.5, 2, 2.5, 2.6),beta_list=list(c(-0.05, 0.01, 0.5, 0.6),
                 c(-0.03, 0.02, 0.07, 0.08),c(-0.04, 0.03, 0.04, -0.03),
                 c(-0.05, 0.05, 0.6, 0.8)),cov_means=c(0, 10, 2, 3),cov_sds=c(1,20,5,1.05),
                 trans_list=list(c(2, 3, 4, 5),c(3, 4, 5),c(4, 5), c(5), c()),
                 state_names=c("Tx", "Rec", "Death", "Reldeath", "srv"))
##
}
\author{
Atanu Bhattacharjee,Gajendra Kumar Vishwakarma,Abhipsa Tripathy
}
