// Bindings generated by `windows-bindgen` 0.65.0

#![allow(
    non_snake_case,
    non_upper_case_globals,
    non_camel_case_types,
    dead_code,
    clippy::all
)]

pub mod Windows {
    pub mod Win32 {
        pub mod Foundation {
            pub const EXCEPTION_STACK_OVERFLOW: NTSTATUS = NTSTATUS(0xC00000FD_u32 as _);
            #[must_use]
            #[repr(transparent)]
            #[derive(Clone, Copy, Debug, PartialEq, Eq, Default)]
            pub struct NTSTATUS(pub i32);
        }
        pub mod System {
            pub mod Diagnostics {
                pub mod Debug {
                    #[inline]
                    pub unsafe fn AddVectoredExceptionHandler(
                        first: u32,
                        handler: PVECTORED_EXCEPTION_HANDLER,
                    ) -> *mut core::ffi::c_void {
                        windows_link::link!("kernel32.dll" "system" fn AddVectoredExceptionHandler(first : u32, handler : PVECTORED_EXCEPTION_HANDLER) -> *mut core::ffi::c_void);
                        unsafe { AddVectoredExceptionHandler(first, handler) }
                    }
                    #[repr(C)]
                    #[derive(Clone, Copy)]
                    pub union ARM64_NT_NEON128 {
                        pub Anonymous: ARM64_NT_NEON128_0,
                        pub D: [f64; 2],
                        pub S: [f32; 4],
                        pub H: [u16; 8],
                        pub B: [u8; 16],
                    }
                    impl Default for ARM64_NT_NEON128 {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[derive(Clone, Copy, Debug, Default, PartialEq)]
                    pub struct ARM64_NT_NEON128_0 {
                        pub Low: u64,
                        pub High: i64,
                    }
                    #[repr(C)]
                    #[cfg(target_arch = "x86")]
                    #[derive(Clone, Copy, Debug, PartialEq)]
                    pub struct CONTEXT {
                        pub ContextFlags: CONTEXT_FLAGS,
                        pub Dr0: u32,
                        pub Dr1: u32,
                        pub Dr2: u32,
                        pub Dr3: u32,
                        pub Dr6: u32,
                        pub Dr7: u32,
                        pub FloatSave: super::super::Kernel::FLOATING_SAVE_AREA,
                        pub SegGs: u32,
                        pub SegFs: u32,
                        pub SegEs: u32,
                        pub SegDs: u32,
                        pub Edi: u32,
                        pub Esi: u32,
                        pub Ebx: u32,
                        pub Edx: u32,
                        pub Ecx: u32,
                        pub Eax: u32,
                        pub Ebp: u32,
                        pub Eip: u32,
                        pub SegCs: u32,
                        pub EFlags: u32,
                        pub Esp: u32,
                        pub SegSs: u32,
                        pub ExtendedRegisters: [u8; 512],
                    }
                    #[cfg(target_arch = "x86")]
                    impl Default for CONTEXT {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[cfg(any(target_arch = "arm64ec", target_arch = "x86_64"))]
                    #[derive(Clone, Copy)]
                    pub struct CONTEXT {
                        pub P1Home: u64,
                        pub P2Home: u64,
                        pub P3Home: u64,
                        pub P4Home: u64,
                        pub P5Home: u64,
                        pub P6Home: u64,
                        pub ContextFlags: CONTEXT_FLAGS,
                        pub MxCsr: u32,
                        pub SegCs: u16,
                        pub SegDs: u16,
                        pub SegEs: u16,
                        pub SegFs: u16,
                        pub SegGs: u16,
                        pub SegSs: u16,
                        pub EFlags: u32,
                        pub Dr0: u64,
                        pub Dr1: u64,
                        pub Dr2: u64,
                        pub Dr3: u64,
                        pub Dr6: u64,
                        pub Dr7: u64,
                        pub Rax: u64,
                        pub Rcx: u64,
                        pub Rdx: u64,
                        pub Rbx: u64,
                        pub Rsp: u64,
                        pub Rbp: u64,
                        pub Rsi: u64,
                        pub Rdi: u64,
                        pub R8: u64,
                        pub R9: u64,
                        pub R10: u64,
                        pub R11: u64,
                        pub R12: u64,
                        pub R13: u64,
                        pub R14: u64,
                        pub R15: u64,
                        pub Rip: u64,
                        pub Anonymous: CONTEXT_0,
                        pub VectorRegister: [M128A; 26],
                        pub VectorControl: u64,
                        pub DebugControl: u64,
                        pub LastBranchToRip: u64,
                        pub LastBranchFromRip: u64,
                        pub LastExceptionToRip: u64,
                        pub LastExceptionFromRip: u64,
                    }
                    #[cfg(any(target_arch = "arm64ec", target_arch = "x86_64"))]
                    impl Default for CONTEXT {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[cfg(any(target_arch = "arm64ec", target_arch = "x86_64"))]
                    #[derive(Clone, Copy)]
                    pub union CONTEXT_0 {
                        pub FltSave: XSAVE_FORMAT,
                        pub Anonymous: CONTEXT_0_0,
                    }
                    #[cfg(any(target_arch = "arm64ec", target_arch = "x86_64"))]
                    impl Default for CONTEXT_0 {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[cfg(any(target_arch = "arm64ec", target_arch = "x86_64"))]
                    #[derive(Clone, Copy, Debug, PartialEq)]
                    pub struct CONTEXT_0_0 {
                        pub Header: [M128A; 2],
                        pub Legacy: [M128A; 8],
                        pub Xmm0: M128A,
                        pub Xmm1: M128A,
                        pub Xmm2: M128A,
                        pub Xmm3: M128A,
                        pub Xmm4: M128A,
                        pub Xmm5: M128A,
                        pub Xmm6: M128A,
                        pub Xmm7: M128A,
                        pub Xmm8: M128A,
                        pub Xmm9: M128A,
                        pub Xmm10: M128A,
                        pub Xmm11: M128A,
                        pub Xmm12: M128A,
                        pub Xmm13: M128A,
                        pub Xmm14: M128A,
                        pub Xmm15: M128A,
                    }
                    #[cfg(any(target_arch = "arm64ec", target_arch = "x86_64"))]
                    impl Default for CONTEXT_0_0 {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[cfg(target_arch = "aarch64")]
                    #[derive(Clone, Copy)]
                    pub struct CONTEXT {
                        pub ContextFlags: CONTEXT_FLAGS,
                        pub Cpsr: u32,
                        pub Anonymous: CONTEXT_0,
                        pub Sp: u64,
                        pub Pc: u64,
                        pub V: [ARM64_NT_NEON128; 32],
                        pub Fpcr: u32,
                        pub Fpsr: u32,
                        pub Bcr: [u32; 8],
                        pub Bvr: [u64; 8],
                        pub Wcr: [u32; 2],
                        pub Wvr: [u64; 2],
                    }
                    #[cfg(target_arch = "aarch64")]
                    impl Default for CONTEXT {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[cfg(target_arch = "aarch64")]
                    #[derive(Clone, Copy)]
                    pub union CONTEXT_0 {
                        pub Anonymous: CONTEXT_0_0,
                        pub X: [u64; 31],
                    }
                    #[cfg(target_arch = "aarch64")]
                    impl Default for CONTEXT_0 {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[cfg(target_arch = "aarch64")]
                    #[derive(Clone, Copy, Debug, Default, PartialEq)]
                    pub struct CONTEXT_0_0 {
                        pub X0: u64,
                        pub X1: u64,
                        pub X2: u64,
                        pub X3: u64,
                        pub X4: u64,
                        pub X5: u64,
                        pub X6: u64,
                        pub X7: u64,
                        pub X8: u64,
                        pub X9: u64,
                        pub X10: u64,
                        pub X11: u64,
                        pub X12: u64,
                        pub X13: u64,
                        pub X14: u64,
                        pub X15: u64,
                        pub X16: u64,
                        pub X17: u64,
                        pub X18: u64,
                        pub X19: u64,
                        pub X20: u64,
                        pub X21: u64,
                        pub X22: u64,
                        pub X23: u64,
                        pub X24: u64,
                        pub X25: u64,
                        pub X26: u64,
                        pub X27: u64,
                        pub X28: u64,
                        pub Fp: u64,
                        pub Lr: u64,
                    }
                    #[repr(transparent)]
                    #[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
                    pub struct CONTEXT_FLAGS(pub u32);
                    impl CONTEXT_FLAGS {
                        pub const fn contains(&self, other: Self) -> bool {
                            self.0 & other.0 == other.0
                        }
                    }
                    impl core::ops::BitOr for CONTEXT_FLAGS {
                        type Output = Self;
                        fn bitor(self, other: Self) -> Self {
                            Self(self.0 | other.0)
                        }
                    }
                    impl core::ops::BitAnd for CONTEXT_FLAGS {
                        type Output = Self;
                        fn bitand(self, other: Self) -> Self {
                            Self(self.0 & other.0)
                        }
                    }
                    impl core::ops::BitOrAssign for CONTEXT_FLAGS {
                        fn bitor_assign(&mut self, other: Self) {
                            self.0.bitor_assign(other.0)
                        }
                    }
                    impl core::ops::BitAndAssign for CONTEXT_FLAGS {
                        fn bitand_assign(&mut self, other: Self) {
                            self.0.bitand_assign(other.0)
                        }
                    }
                    impl core::ops::Not for CONTEXT_FLAGS {
                        type Output = Self;
                        fn not(self) -> Self {
                            Self(self.0.not())
                        }
                    }
                    #[repr(C)]
                    #[derive(Clone, Copy, Debug, PartialEq)]
                    pub struct EXCEPTION_POINTERS {
                        pub ExceptionRecord: *mut EXCEPTION_RECORD,
                        pub ContextRecord: *mut CONTEXT,
                    }
                    impl Default for EXCEPTION_POINTERS {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[derive(Clone, Copy, Debug, PartialEq)]
                    pub struct EXCEPTION_RECORD {
                        pub ExceptionCode: super::super::super::Foundation::NTSTATUS,
                        pub ExceptionFlags: u32,
                        pub ExceptionRecord: *mut EXCEPTION_RECORD,
                        pub ExceptionAddress: *mut core::ffi::c_void,
                        pub NumberParameters: u32,
                        pub ExceptionInformation: [usize; 15],
                    }
                    impl Default for EXCEPTION_RECORD {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[derive(Clone, Copy, Debug, Default, PartialEq)]
                    pub struct M128A {
                        pub Low: u64,
                        pub High: i64,
                    }
                    pub type PVECTORED_EXCEPTION_HANDLER = Option<
                        unsafe extern "system" fn(exceptioninfo: *mut EXCEPTION_POINTERS) -> i32,
                    >;
                    #[repr(C)]
                    #[cfg(target_arch = "x86")]
                    #[derive(Clone, Copy, Debug, PartialEq)]
                    pub struct XSAVE_FORMAT {
                        pub ControlWord: u16,
                        pub StatusWord: u16,
                        pub TagWord: u8,
                        pub Reserved1: u8,
                        pub ErrorOpcode: u16,
                        pub ErrorOffset: u32,
                        pub ErrorSelector: u16,
                        pub Reserved2: u16,
                        pub DataOffset: u32,
                        pub DataSelector: u16,
                        pub Reserved3: u16,
                        pub MxCsr: u32,
                        pub MxCsr_Mask: u32,
                        pub FloatRegisters: [M128A; 8],
                        pub XmmRegisters: [M128A; 8],
                        pub Reserved4: [u8; 224],
                    }
                    #[cfg(target_arch = "x86")]
                    impl Default for XSAVE_FORMAT {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                    #[repr(C)]
                    #[cfg(any(
                        target_arch = "aarch64",
                        target_arch = "arm64ec",
                        target_arch = "x86_64"
                    ))]
                    #[derive(Clone, Copy, Debug, PartialEq)]
                    pub struct XSAVE_FORMAT {
                        pub ControlWord: u16,
                        pub StatusWord: u16,
                        pub TagWord: u8,
                        pub Reserved1: u8,
                        pub ErrorOpcode: u16,
                        pub ErrorOffset: u32,
                        pub ErrorSelector: u16,
                        pub Reserved2: u16,
                        pub DataOffset: u32,
                        pub DataSelector: u16,
                        pub Reserved3: u16,
                        pub MxCsr: u32,
                        pub MxCsr_Mask: u32,
                        pub FloatRegisters: [M128A; 8],
                        pub XmmRegisters: [M128A; 16],
                        pub Reserved4: [u8; 96],
                    }
                    #[cfg(any(
                        target_arch = "aarch64",
                        target_arch = "arm64ec",
                        target_arch = "x86_64"
                    ))]
                    impl Default for XSAVE_FORMAT {
                        fn default() -> Self {
                            unsafe { core::mem::zeroed() }
                        }
                    }
                }
            }
            pub mod Kernel {
                #[repr(C)]
                #[cfg(target_arch = "x86")]
                #[derive(Clone, Copy, Debug, PartialEq)]
                pub struct FLOATING_SAVE_AREA {
                    pub ControlWord: u32,
                    pub StatusWord: u32,
                    pub TagWord: u32,
                    pub ErrorOffset: u32,
                    pub ErrorSelector: u32,
                    pub DataOffset: u32,
                    pub DataSelector: u32,
                    pub RegisterArea: [u8; 80],
                    pub Spare0: u32,
                }
                #[cfg(target_arch = "x86")]
                impl Default for FLOATING_SAVE_AREA {
                    fn default() -> Self {
                        unsafe { core::mem::zeroed() }
                    }
                }
                #[repr(C)]
                #[cfg(any(
                    target_arch = "aarch64",
                    target_arch = "arm64ec",
                    target_arch = "x86_64"
                ))]
                #[derive(Clone, Copy, Debug, PartialEq)]
                pub struct FLOATING_SAVE_AREA {
                    pub ControlWord: u32,
                    pub StatusWord: u32,
                    pub TagWord: u32,
                    pub ErrorOffset: u32,
                    pub ErrorSelector: u32,
                    pub DataOffset: u32,
                    pub DataSelector: u32,
                    pub RegisterArea: [u8; 80],
                    pub Cr0NpxState: u32,
                }
                #[cfg(any(
                    target_arch = "aarch64",
                    target_arch = "arm64ec",
                    target_arch = "x86_64"
                ))]
                impl Default for FLOATING_SAVE_AREA {
                    fn default() -> Self {
                        unsafe { core::mem::zeroed() }
                    }
                }
            }
            pub mod Memory {
                #[inline]
                pub unsafe fn VirtualAlloc(
                    lpaddress: Option<*const core::ffi::c_void>,
                    dwsize: usize,
                    flallocationtype: VIRTUAL_ALLOCATION_TYPE,
                    flprotect: PAGE_PROTECTION_FLAGS,
                ) -> *mut core::ffi::c_void {
                    windows_link::link!("kernel32.dll" "system" fn VirtualAlloc(lpaddress : *const core::ffi::c_void, dwsize : usize, flallocationtype : VIRTUAL_ALLOCATION_TYPE, flprotect : PAGE_PROTECTION_FLAGS) -> *mut core::ffi::c_void);
                    unsafe {
                        VirtualAlloc(
                            lpaddress.unwrap_or(core::mem::zeroed()) as _,
                            dwsize,
                            flallocationtype,
                            flprotect,
                        )
                    }
                }
                #[inline]
                pub unsafe fn VirtualFree(
                    lpaddress: *mut core::ffi::c_void,
                    dwsize: usize,
                    dwfreetype: VIRTUAL_FREE_TYPE,
                ) -> windows_result::Result<()> {
                    windows_link::link!("kernel32.dll" "system" fn VirtualFree(lpaddress : *mut core::ffi::c_void, dwsize : usize, dwfreetype : VIRTUAL_FREE_TYPE) -> windows_result::BOOL);
                    unsafe { VirtualFree(lpaddress as _, dwsize, dwfreetype).ok() }
                }
                #[inline]
                pub unsafe fn VirtualProtect(
                    lpaddress: *const core::ffi::c_void,
                    dwsize: usize,
                    flnewprotect: PAGE_PROTECTION_FLAGS,
                    lpfloldprotect: *mut PAGE_PROTECTION_FLAGS,
                ) -> windows_result::Result<()> {
                    windows_link::link!("kernel32.dll" "system" fn VirtualProtect(lpaddress : *const core::ffi::c_void, dwsize : usize, flnewprotect : PAGE_PROTECTION_FLAGS, lpfloldprotect : *mut PAGE_PROTECTION_FLAGS) -> windows_result::BOOL);
                    unsafe {
                        VirtualProtect(lpaddress, dwsize, flnewprotect, lpfloldprotect as _).ok()
                    }
                }
                pub const MEM_COMMIT: VIRTUAL_ALLOCATION_TYPE = VIRTUAL_ALLOCATION_TYPE(4096u32);
                pub const MEM_RELEASE: VIRTUAL_FREE_TYPE = VIRTUAL_FREE_TYPE(32768u32);
                pub const MEM_RESERVE: VIRTUAL_ALLOCATION_TYPE = VIRTUAL_ALLOCATION_TYPE(8192u32);
                pub const PAGE_GUARD: PAGE_PROTECTION_FLAGS = PAGE_PROTECTION_FLAGS(256u32);
                #[repr(transparent)]
                #[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
                pub struct PAGE_PROTECTION_FLAGS(pub u32);
                impl PAGE_PROTECTION_FLAGS {
                    pub const fn contains(&self, other: Self) -> bool {
                        self.0 & other.0 == other.0
                    }
                }
                impl core::ops::BitOr for PAGE_PROTECTION_FLAGS {
                    type Output = Self;
                    fn bitor(self, other: Self) -> Self {
                        Self(self.0 | other.0)
                    }
                }
                impl core::ops::BitAnd for PAGE_PROTECTION_FLAGS {
                    type Output = Self;
                    fn bitand(self, other: Self) -> Self {
                        Self(self.0 & other.0)
                    }
                }
                impl core::ops::BitOrAssign for PAGE_PROTECTION_FLAGS {
                    fn bitor_assign(&mut self, other: Self) {
                        self.0.bitor_assign(other.0)
                    }
                }
                impl core::ops::BitAndAssign for PAGE_PROTECTION_FLAGS {
                    fn bitand_assign(&mut self, other: Self) {
                        self.0.bitand_assign(other.0)
                    }
                }
                impl core::ops::Not for PAGE_PROTECTION_FLAGS {
                    type Output = Self;
                    fn not(self) -> Self {
                        Self(self.0.not())
                    }
                }
                pub const PAGE_READONLY: PAGE_PROTECTION_FLAGS = PAGE_PROTECTION_FLAGS(2u32);
                pub const PAGE_READWRITE: PAGE_PROTECTION_FLAGS = PAGE_PROTECTION_FLAGS(4u32);
                #[repr(transparent)]
                #[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
                pub struct VIRTUAL_ALLOCATION_TYPE(pub u32);
                impl VIRTUAL_ALLOCATION_TYPE {
                    pub const fn contains(&self, other: Self) -> bool {
                        self.0 & other.0 == other.0
                    }
                }
                impl core::ops::BitOr for VIRTUAL_ALLOCATION_TYPE {
                    type Output = Self;
                    fn bitor(self, other: Self) -> Self {
                        Self(self.0 | other.0)
                    }
                }
                impl core::ops::BitAnd for VIRTUAL_ALLOCATION_TYPE {
                    type Output = Self;
                    fn bitand(self, other: Self) -> Self {
                        Self(self.0 & other.0)
                    }
                }
                impl core::ops::BitOrAssign for VIRTUAL_ALLOCATION_TYPE {
                    fn bitor_assign(&mut self, other: Self) {
                        self.0.bitor_assign(other.0)
                    }
                }
                impl core::ops::BitAndAssign for VIRTUAL_ALLOCATION_TYPE {
                    fn bitand_assign(&mut self, other: Self) {
                        self.0.bitand_assign(other.0)
                    }
                }
                impl core::ops::Not for VIRTUAL_ALLOCATION_TYPE {
                    type Output = Self;
                    fn not(self) -> Self {
                        Self(self.0.not())
                    }
                }
                #[repr(transparent)]
                #[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
                pub struct VIRTUAL_FREE_TYPE(pub u32);
            }
            pub mod SystemInformation {
                #[inline]
                pub unsafe fn GetSystemInfo(lpsysteminfo: *mut SYSTEM_INFO) {
                    windows_link::link!("kernel32.dll" "system" fn GetSystemInfo(lpsysteminfo : *mut SYSTEM_INFO));
                    unsafe { GetSystemInfo(lpsysteminfo as _) }
                }
                #[repr(transparent)]
                #[derive(Clone, Copy, Debug, Default, Eq, PartialEq)]
                pub struct PROCESSOR_ARCHITECTURE(pub u16);
                #[repr(C)]
                #[derive(Clone, Copy)]
                pub struct SYSTEM_INFO {
                    pub Anonymous: SYSTEM_INFO_0,
                    pub dwPageSize: u32,
                    pub lpMinimumApplicationAddress: *mut core::ffi::c_void,
                    pub lpMaximumApplicationAddress: *mut core::ffi::c_void,
                    pub dwActiveProcessorMask: usize,
                    pub dwNumberOfProcessors: u32,
                    pub dwProcessorType: u32,
                    pub dwAllocationGranularity: u32,
                    pub wProcessorLevel: u16,
                    pub wProcessorRevision: u16,
                }
                impl Default for SYSTEM_INFO {
                    fn default() -> Self {
                        unsafe { core::mem::zeroed() }
                    }
                }
                #[repr(C)]
                #[derive(Clone, Copy)]
                pub union SYSTEM_INFO_0 {
                    pub dwOemId: u32,
                    pub Anonymous: SYSTEM_INFO_0_0,
                }
                impl Default for SYSTEM_INFO_0 {
                    fn default() -> Self {
                        unsafe { core::mem::zeroed() }
                    }
                }
                #[repr(C)]
                #[derive(Clone, Copy, Debug, Default, PartialEq)]
                pub struct SYSTEM_INFO_0_0 {
                    pub wProcessorArchitecture: PROCESSOR_ARCHITECTURE,
                    pub wReserved: u16,
                }
            }
        }
    }
}
