% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_narrower_transitive.R
\name{get_narrower_transitive}
\alias{get_narrower_transitive}
\title{Get narrower transitive concepts for a specific concept from the Finto Skosmos API}
\usage{
get_narrower_transitive(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept whose narrower transitive hierarchy to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing the narrower transitive concepts (prefLabel and uri) for the specified concept.
}
\description{
Get narrower transitive concepts for a specific concept from the Finto Skosmos API
}
\examples{
narrow <- get_narrower_transitive(vocid = "yso",
uri = "http://www.yso.fi/onto/yso/p690", lang = "fi")
print(narrow)
}
