% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mappings.R
\name{get_mappings}
\alias{get_mappings}
\title{Get mappings for a specific concept from the Finto Skosmos API}
\usage{
get_mappings(vocid, uri, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{uri}{The URI of the concept whose mappings to retrieve.}

\item{lang}{The language code for the labels, e.g., "fi" or "en". Optional.}
}
\value{
A tibble containing mappings associated with the specified concept.
}
\description{
Get mappings for a specific concept from the Finto Skosmos API
}
\examples{
mappings_data <- get_mappings(vocid = "yso", uri = "http://www.yso.fi/onto/yso/p22922", lang = "fi")
print(mappings_data)
}
