% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{warp_curve}
\alias{warp_curve}
\title{Applies a warping function to a given curve}
\usage{
warp_curve(betafun, gamfun)
}
\arguments{
\item{betafun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the underlying curve at
\eqn{s}.}

\item{gamfun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of a diffeomorphic warping
function at \eqn{s}.}
}
\value{
A function that takes a numeric vector \eqn{s} of values in \eqn{[0,
  1]} as input and returns the values of the warped curve at \eqn{s}.
}
\description{
Applies a warping function to a given curve
}
\examples{
curv <- discrete2curve(beta[, , 1, 1])
gamf <- discrete2warping(seq(0, 1, length = 100)^2)
warp_curve(curv, gamf)
}
