% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Download FCA Call Report Data and Unzip}
\usage{
download_data(year, month, dest, files = NULL, quiet = FALSE)
}
\arguments{
\item{year}{(Integer) The year of the Call Report (e.g., \code{2022})}

\item{month}{(String) The month of the Call Report (e.g., \code{"March"}); you may
also supply an integer (e.g., \code{3}) representing the month numerically}

\item{dest}{(String) The path to the directory where the data will be
downloaded (and unzipped) into}

\item{files}{(Optional) Character vector, representing the names of the files
in the .zip archive to be downloaded; default is \code{NULL}, meaning all files
will be downloaded}

\item{quiet}{(Optional) Logical. Controls whether download progress messages
are displayed in the console. Defaults to \code{TRUE}.}
}
\value{
Console message informing the user where the data was successfully
downloaded (and unzipped) into
}
\description{
Download FCA Call Report Data and Unzip
}
\details{
FCA publishes Call Report data quarterly. These .zip files are
typically named "\code{YYYY}March.zip", "\code{YYYY}June.zip", "\code{YYYY}September.zip"
and "\code{YYYY}December.zip" (where \code{YYYY} represents the 4-digit year).
Therefore, valid values to the \code{month} argument should be limited to
\code{c(3, 6, 9, 12)}, unless there is an anomaly in FCA's reporting/publishing.
Check \url{https://www.fca.gov/bank-oversight/call-report-data-for-download} to
ensure the data is available for the quarter you are interested in.
Ketchbrook Analytics downloads these files and stores them in a public AWS
S3 bucket, which is the location that \code{download_data()} retrieves them
from.
}
\examples{
\donttest{

  path_1 <- tempfile("fcadata1")
  dir.create(path_1)

  download_data(
    year = 2025,
    month = "September",   # using the name of the month
    dest = path_1
  )

  list.files(path_1)

  path_2 <- tempfile("fcadata2")
  dir.create(path_2)

  download_data(
    year = 2025,
    month = 9,   # using the month number (to refer to September)
    dest = path_2,
    # only download the following files
    files = c(
      "D_INST.TXT",
      "INST_Q202509_G20251112.TXT"
    )
  )

  list.files(path_2)

}
}
