% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_count.R
\name{f_count}
\alias{f_count}
\alias{f_add_count}
\title{A fast replacement to dplyr::count()}
\usage{
f_count(
  .data,
  ...,
  wt = NULL,
  sort = FALSE,
  .order = group_by_order_default(.data),
  name = NULL,
  .by = NULL,
  .cols = NULL
)

f_add_count(
  .data,
  ...,
  wt = NULL,
  sort = FALSE,
  .order = group_by_order_default(.data),
  name = NULL,
  .by = NULL,
  .cols = NULL
)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Variables to group by.}

\item{wt}{Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{.order}{Should the groups be calculated as ordered groups?
If \code{FALSE}, this will return the groups in order of first appearance,
and in many cases is faster.
If \code{TRUE} (the default), the groups are returned in sorted order,
exactly the same way as \code{dplyr::count}.}

\item{name}{The name of the new column in the output.
If there's already a column called \code{n},
it will use \code{nn}.
If there's a column called \code{n} and \code{n}n,
it'll use \code{nnn}, and so on, adding \code{n}s until it gets a new name.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}
}
\value{
A \code{data.frame} of frequency counts by group.
}
\description{
Near-identical alternative to \code{dplyr::count()}.
}
\details{
This is a fast and near-identical alternative to dplyr::count() using the \code{collapse} package.
Unlike \code{collapse::fcount()}, this works very similarly to \code{dplyr::count()}.
The only main difference is that anything supplied to \code{wt}
is recycled and added as a data variable.
Other than that everything works exactly as the dplyr equivalent.

\code{f_count()} and \code{f_add_count()} can be up to >100x faster than the dplyr equivalents.
}
