% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qr_Qy}
\alias{qr_Qy}
\title{Multiply Q by a vector using a QR decomposition}
\usage{
qr_Qy(qr, tau, y)
}
\arguments{
\item{qr}{numeric matrix containing the QR decomposition in compact form
(as returned by \code{qr_fast()}).}

\item{tau}{numeric vector of Householder coefficients.}

\item{y}{numeric vector of length \eqn{n}.}
}
\value{
a numeric vector equal to \eqn{Q y}.
}
\description{
Computes \eqn{Q y}, where \eqn{Q} is the orthogonal matrix from the
QR decomposition stored in compact (Householder) form.
}
\details{
The orthogonal matrix \eqn{Q} is not formed explicitly. The product
\eqn{Q y} is computed efficiently using the Householder reflectors
stored in \code{qr} and \code{tau}.
}
\examples{
set.seed(1)
n <- 10; p <- 4
X <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)

qr_res <- fastQR::qr_fast(X)
res1   <- fastQR::qr_Qy(qr = qr_res$qr, tau = qr_res$qraux, y = y)

## reference computation
Q    <- base::qr.Q(base::qr(X), complete = TRUE)
res2 <- Q \%*\% y

max(abs(res1 - drop(res2)))

}
