% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{fitted.FASSTER}
\alias{fitted.FASSTER}
\title{Extract fitted values from a FASSTER model}
\usage{
\method{fitted}{FASSTER}(object, ...)
}
\arguments{
\item{object}{A fitted FASSTER model object.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A numeric vector of fitted values with the same length as the
training data.
}
\description{
Returns the one-step-ahead fitted values from a FASSTER model, calculated
during the Kalman filtering process. These represent the model's predictions
at each time point using only information available up to that point.
}
\examples{
library(tsibble)
fit <- as_tsibble(mdeaths) |>
  model(FASSTER(value ~ trend(1) + fourier(12)))

# Extract fitted values
fitted(fit)

}
