% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{TSLM}
\alias{TSLM}
\alias{report.TSLM}
\title{Fit a linear model with time series components}
\usage{
TSLM(formula)
}
\arguments{
\item{formula}{Model specification.}
}
\value{
A model specification.
}
\description{
The model formula will be handled using \code{\link[stats:model.matrix]{stats::model.matrix()}}, and so
the the same approach to include interactions in \code{\link[stats:lm]{stats::lm()}} applies when
specifying the \code{formula}. In addition to \code{\link[stats:lm]{stats::lm()}}, it is possible to
include \code{\link{common_xregs}} in the model formula, such as \code{trend()}, \code{season()},
and \code{fourier()}.
}
\section{Specials}{


\subsection{xreg}{
Exogenous regressors can be included in a TSLM model without explicitly using the \code{xreg()} special. Common exogenous regressor specials as specified in \code{\link{common_xregs}} can also be used. These regressors are handled using \code{\link[stats:model.frame]{stats::model.frame()}}, and so interactions and other functionality behaves similarly to \code{\link[stats:lm]{stats::lm()}}.
\preformatted{
xreg(...)
}

\tabular{ll}{
\code{...}      \tab Bare expressions for the exogenous regressors (such as \code{log(x)})
}
}
}

\examples{
as_tsibble(USAccDeaths) \%>\%
  model(lm = TSLM(log(value) ~ trend() + season()))

library(tsibbledata)
olympic_running \%>\%
  model(TSLM(Time ~ trend())) \%>\%
  interpolate(olympic_running)
}
\seealso{
\code{\link[stats:lm]{stats::lm()}}, \code{\link[stats:model.matrix]{stats::model.matrix()}}
\href{https://otexts.com/fpp3/regression.html}{Forecasting: Principles and Practices, Time series regression models (chapter 6)}
}
