% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{send_whatsapp_audio}
\alias{send_whatsapp_audio}
\title{Send WhatsApp audio (voice note)}
\usage{
send_whatsapp_audio(
  client,
  number,
  audio,
  delay = NULL,
  quoted = NULL,
  verbose = FALSE
)
}
\arguments{
\item{client}{An \code{\link[=evo_client]{evo_client()}} object.}

\item{number}{Character. Recipient number with country code
(e.g., \code{"5581999990000"} or \code{"+5581999990000"}).}

\item{audio}{URL, base64-encoded audio, or local file path
(auto-encoded to base64). Supports \code{~} expansion.}

\item{delay}{Integer (ms). Optional presence delay before sending.
Simulates typing before the message is sent.}

\item{quoted}{Optional list with Baileys message \code{key} and \code{message}
to reply to a specific message.}

\item{verbose}{Logical. If \code{TRUE}, logs request/response details with
\strong{cli}.}
}
\value{
A named list with the API response. The HTTP status code is
stored in \code{attr(result, "http_status")}.
}
\description{
Sends an audio message (push-to-talk / voice note) via
Evolution API v2.
}
\examples{
\dontrun{
send_whatsapp_audio(client, "5581999990000",
                    audio = "https://example.com/note.ogg")
}
}
