.evidence_result <- function(estimate, interval, interval_level,
                             log10_er, null, alternative, model, call) {

  stopifnot(length(estimate) == 1L)
  stopifnot(length(interval) == 2L)
  stopifnot(length(log10_er) == 1L)

  structure(
    list(
      estimate = estimate,
      interval = interval,
      interval_level = interval_level,
      log10_er = log10_er,
      null = null,
      alternative = alternative,
      model = model,
      call = call
    ),
    class = "evidence_result"
  )
}

#' @export
print.evidence_result <- function(x, digits = getOption("digits"), ...) {
  cat("Evidence test\n\n")
  cat("Estimate:       ", formatC(x$estimate, digits = digits), "\n", sep = "")
  cat("Interval (", round(100 * x$interval_level), "%):  [",
      formatC(x$interval[1], digits = digits), ", ",
      formatC(x$interval[2], digits = digits), "]\n", sep = "")
  cat("log10 ER:       ", formatC(x$log10_er, digits = 3), "\n\n", sep = "")
  cat("Model:          ", x$model, "\n", sep = "")
  cat("Null hypothesis:", x$null, "\n", sep = "")
  invisible(x)
}

